/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile.datasource;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DerbyPooledDataSource
extends BasicDataSource {
    private static final long serialVersionUID = -8613139738021279720L;
    private static final String NO_CREATE_URL = "{none}";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String createUrl = "{none}";

    public void init() throws SQLException {
        String droidLogDir = System.getProperty("droidLogDir");
        System.setProperty("derby.stream.error.file", new File(droidLogDir, "derby.log").getPath());
        this.setDefaultTransactionIsolation(1);
        this.setDefaultAutoCommit(false);
        this.log.debug((Object)String.format("Booting database [%s]", this.getUrl()));
        String url = this.getCreateURL();
        String driverClassName = this.getDriverClassName();
        try {
            Class.forName(driverClassName);
            DriverManager.getConnection(url).close();
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Invalid driver class name: %s", driverClassName);
            this.log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    private String getCreateURL() {
        String url = this.getUrl() + ";create=true";
        if (this.createUrl != null && !this.createUrl.isEmpty() && !NO_CREATE_URL.equals(this.createUrl)) {
            url = url + ";" + this.createUrl;
        }
        return url;
    }

    public void shutdown() throws SQLException {
        this.log.debug((Object)String.format("Closing database [%s]", this.getUrl()));
        this.close();
        String url = this.getUrl() + ";shutdown=true";
        try {
            DriverManager.getConnection(url);
        }
        catch (SQLNonTransientConnectionException e) {
            if ("08006".equals(e.getSQLState())) {
                this.log.debug((Object)e.getMessage());
            }
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void freeze() {
        this.log.debug((Object)String.format("Freezing database [%s]", this.getUrl()));
        try {
            Statement s = DriverManager.getConnection(this.getUrl()).createStatement();
            s.executeUpdate("CALL SYSCS_UTIL.SYSCS_FREEZE_DATABASE()");
            s.close();
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void thaw() {
        this.log.debug((Object)String.format("Derby thawing database [%s]", this.getUrl()));
        try {
            Statement s = DriverManager.getConnection(this.getUrl()).createStatement();
            s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE()");
            s.close();
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setCreateUrl(String createUrl) {
        this.createUrl = createUrl;
    }
}

