/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile.export;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;
import uk.gov.nationalarchives.droid.profile.SqlUtils;

public class HqlFilterParser {
    private final Log log = LogFactory.getLog(this.getClass());

    public Query parse(Filter filter, Session hibernateSession, String baseQuery) {
        QueryBuilder queryBuilder = SqlUtils.getQueryBuilder(filter);
        String ejbFilter = queryBuilder.toEjbQl();
        String startQuery = baseQuery;
        if (ejbFilter.contains("format.")) {
            startQuery = baseQuery + " INNER JOIN profileResourceNode.formatIdentifications as format ";
        }
        String queryString = startQuery + " WHERE " + ejbFilter;
        this.log.debug((Object)("Query = " + queryString));
        Query query = hibernateSession.createQuery(queryString);
        int i = 0;
        for (Object value : queryBuilder.getValues()) {
            query.setParameter(i++, value);
        }
        return query;
    }
}

