/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile.export;

import java.util.ArrayList;
import org.hibernate.FlushMode;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReader;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReaderCallback;
import uk.gov.nationalarchives.droid.export.interfaces.JobCancellationException;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.SqlUtils;

public class SqlItemReader<T>
implements ItemReader<T> {
    private SessionFactory sessionFactory;
    private Session session;
    private ScrollableResults cursor;
    private int fetchSize;
    private int chunkSize;

    public T read() {
        if (this.cursor.next()) {
            Object[] data = this.cursor.get();
            Object item = data[0];
            return (T)item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAll(ItemReaderCallback<T> callback, Filter filter) throws JobCancellationException {
        this.open(filter);
        try {
            T item;
            ArrayList<T> chunk = new ArrayList<T>();
            while ((item = this.read()) != null) {
                chunk.add(item);
                if (chunk.size() != this.chunkSize) continue;
                callback.onItem(chunk);
                chunk = new ArrayList();
                this.session.clear();
            }
            if (!chunk.isEmpty()) {
                callback.onItem(chunk);
                chunk = new ArrayList();
                this.session.clear();
            }
        }
        finally {
            this.close();
        }
    }

    public void open(Filter filter) {
        this.cursor = this.getForwardOnlyCursor(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            finally {
                this.session = null;
            }
        }
    }

    private ScrollableResults getForwardOnlyCursor(Filter filter) {
        SQLQuery query;
        boolean filterExists;
        if (this.session == null) {
            this.session = this.sessionFactory.openSession();
            this.session.setFlushMode(FlushMode.MANUAL);
        }
        String queryString = "";
        boolean bl = filterExists = filter != null && filter.isEnabled();
        if (filterExists) {
            QueryBuilder queryBuilder = SqlUtils.getQueryBuilder(filter);
            String ejbFragment = queryBuilder.toEjbQl();
            boolean formatCriteriaExist = ejbFragment.contains("format.");
            String sqlFilter = SqlUtils.transformEJBtoSQLFields(ejbFragment, "profile", "form");
            queryString = formatCriteriaExist ? "select distinct profile.* " : "select profile.* ";
            queryString = queryString + "from profile_resource_node as profile ";
            if (formatCriteriaExist) {
                queryString = queryString + "inner join identification as ident on ident.node_id = profile.node_id inner join format as form on form.puid = ident.puid ";
            }
            queryString = queryString + "where " + sqlFilter;
            query = this.session.createSQLQuery(queryString).addEntity(ProfileResourceNode.class);
            int i = 0;
            for (Object value : queryBuilder.getValues()) {
                Object value2 = SqlUtils.transformParameterToSQLValue(value);
                query.setParameter(i++, value2);
            }
        } else {
            queryString = "select * from profile_resource_node";
            query = this.session.createSQLQuery(queryString).addEntity(ProfileResourceNode.class);
        }
        return query.setFetchSize(this.fetchSize).scroll(ScrollMode.FORWARD_ONLY);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }
}

