/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import uk.gov.nationalarchives.droid.report.dao.GroupByField;
import uk.gov.nationalarchives.droid.report.dao.ReportFieldType;
import uk.gov.nationalarchives.droid.report.dao.ReportLineItem;

public class DateFieldType
implements ReportFieldType {
    private static final int COUNT_INDEX = 0;
    private static final int EARLIEST_INDEX = 1;
    private static final int LATEST_INDEX = 2;
    private static final int GROUP_INDEX = 3;
    private String field;
    private boolean isGroupByExists;
    private List<GroupByField> groupingFields;

    public DateFieldType(String field) {
        this.field = field;
    }

    @Override
    public String getSelectFieldString(List<GroupByField> groupByFields) {
        StringBuilder selectFieldQueryString = new StringBuilder();
        selectFieldQueryString.append("count(" + this.field + "), min(" + this.field + "), max(" + this.field + ") ");
        this.groupingFields = groupByFields;
        boolean bl = this.isGroupByExists = groupByFields != null && groupByFields.size() > 0;
        if (this.isGroupByExists) {
            for (GroupByField group : this.groupingFields) {
                selectFieldQueryString.append(" , ");
                String function = group.getFunction();
                if (function != null && !function.isEmpty()) {
                    selectFieldQueryString.append(function + "(");
                }
                String groupByFieldName = group.getGroupByField().getType().getField();
                selectFieldQueryString.append(groupByFieldName);
                if (function == null || function.isEmpty()) continue;
                selectFieldQueryString.append(")");
            }
        }
        return selectFieldQueryString.toString();
    }

    @Override
    public List<ReportLineItem> populateReportedData(List<?> results) {
        ArrayList<ReportLineItem> lineItems = new ArrayList<ReportLineItem>();
        for (Object res : results) {
            Timestamp timestamp;
            ReportLineItem reportLineItem = new ReportLineItem();
            Object[] resultsArray = (Object[])res;
            Object count = resultsArray[0];
            Object earlyTime = resultsArray[1];
            Object latestTime = resultsArray[2];
            if (count != null) {
                reportLineItem.setCount(new Long(((Integer)count).intValue()));
            }
            if ((timestamp = (Timestamp)earlyTime) != null) {
                reportLineItem.setEarliestDate(timestamp);
            }
            if ((timestamp = (Timestamp)latestTime) != null) {
                reportLineItem.setLatestDate(timestamp);
            }
            if (this.isGroupByExists) {
                ArrayList<String> values = new ArrayList<String>();
                for (int valueIndex = 0; valueIndex < this.groupingFields.size(); ++valueIndex) {
                    values.add(this.getFieldValue(resultsArray[3 + valueIndex]));
                }
                reportLineItem.setGroupByValues(values);
            }
            lineItems.add(reportLineItem);
        }
        return lineItems;
    }

    @Override
    public String getField() {
        return this.field;
    }

    private String getFieldValue(Object value) {
        return value == null ? "" : value.toString();
    }
}

