/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.results.handlers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationErrorType;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.results.handlers.ProgressMonitor;

public class BatchResultHandler
implements ResultHandler {
    private static final int DEFAULT_BATCH_SIZE = 50;
    private Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext
    private EntityManager entityManager;
    private EntityManagerFactory entityManagerFactory;
    private ProgressMonitor progressMonitor;
    private AtomicLong nodeIdValue;
    private List<ProfileResourceNode> batchedNodes = Collections.synchronizedList(new ArrayList());
    private int batchSize = 50;

    public void init() {
        Long maxNodeId = this.getMaxNodeId();
        this.nodeIdValue = maxNodeId == null ? new AtomicLong(0L) : new AtomicLong(maxNodeId + 1L);
    }

    @Transactional
    private Long getMaxNodeId() {
        String maxNodeQuery = "select max(node_id) from profile_resource_node";
        Query q = this.entityManager.createNativeQuery(maxNodeQuery);
        Object result = q.getSingleResult();
        return (Long)result;
    }

    public ResourceId handle(IdentificationResultCollection results) {
        ProfileResourceNode node = new ProfileResourceNode(results.getUri());
        RequestMetaData requestMetaData = results.getRequestMetaData();
        NodeMetaData metaData = new NodeMetaData();
        metaData.setLastModified(requestMetaData.getTime());
        metaData.setSize(results.getFileLength());
        metaData.setName(requestMetaData.getName());
        metaData.setExtension(ResourceUtils.getExtension((String)requestMetaData.getName()));
        metaData.setResourceType(results.isArchive() ? ResourceType.CONTAINER : ResourceType.FILE);
        metaData.setHash(requestMetaData.getHash());
        metaData.setNodeStatus(NodeStatus.DONE);
        node.setMetaData(metaData);
        node.setExtensionMismatch(results.getExtensionMismatch());
        node.setFinished(new Date());
        ResourceId parentId = results.getCorrelationId();
        this.setNodeIds(node, parentId);
        if (results.getResults().isEmpty()) {
            node.addFormatIdentification(Format.NULL);
            node.setZeroIdentifications();
        } else {
            for (IdentificationResult result : results.getResults()) {
                node.getMetaData().setIdentificationMethod(result.getMethod());
                Format format = this.loadFormat(result.getPuid());
                node.addFormatIdentification(format);
            }
        }
        this.progressMonitor.stopJob(node);
        this.batchNode(node);
        return new ResourceId(node.getId().longValue(), node.getPrefix());
    }

    public ResourceId handleDirectory(IdentificationResult result, ResourceId parentId, boolean restricted) {
        URI uri = result.getIdentifier().getUri();
        ProfileResourceNode node = new ProfileResourceNode(uri);
        RequestMetaData requestMetaData = result.getMetaData();
        NodeMetaData metaData = new NodeMetaData();
        metaData.setName(requestMetaData.getName());
        metaData.setSize(null);
        metaData.setLastModified(requestMetaData.getTime());
        metaData.setIdentificationMethod(IdentificationMethod.NULL);
        metaData.setNodeStatus(restricted ? NodeStatus.ACCESS_DENIED : NodeStatus.DONE);
        metaData.setResourceType(ResourceType.FOLDER);
        node.setMetaData(metaData);
        this.setNodeIds(node, parentId);
        node.setFinished(new Date());
        node.addFormatIdentification(Format.NULL);
        this.progressMonitor.stopJob(node);
        this.batchNode(node);
        return new ResourceId(node.getId().longValue(), node.getPrefix());
    }

    private NodeStatus getNodeStatus(IdentificationErrorType error) {
        NodeStatus status;
        switch (error) {
            case ACCESS_DENIED: {
                status = NodeStatus.ACCESS_DENIED;
                break;
            }
            case FILE_NOT_FOUND: {
                status = NodeStatus.NOT_FOUND;
                break;
            }
            default: {
                status = NodeStatus.ERROR;
            }
        }
        return status;
    }

    public void handleError(IdentificationException e) {
        ProfileResourceNode node;
        IdentificationRequest request = e.getRequest();
        RequestIdentifier identifier = request.getIdentifier();
        URI uri = identifier.getUri();
        Long nodeId = identifier.getNodeId();
        if (nodeId != null) {
            node = this.loadNode(nodeId);
            node.getMetaData().setNodeStatus(NodeStatus.ERROR);
            node.getFormatIdentifications().size();
        } else {
            node = new ProfileResourceNode(uri);
            node.setFinished(new Date());
            NodeMetaData metaData = node.getMetaData();
            metaData.setNodeStatus(this.getNodeStatus(e.getErrorType()));
            metaData.setResourceType(ResourceType.FILE);
            node.setNoFormatsIdentified();
            RequestMetaData requestMetaData = request.getRequestMetaData();
            metaData.setName(requestMetaData.getName());
            metaData.setSize(requestMetaData.getSize());
            metaData.setExtension(request.getExtension());
            metaData.setLastModified(request.getRequestMetaData().getTime());
            metaData.setHash(requestMetaData.getHash());
            node.addFormatIdentification(Format.NULL);
            this.setNodeIds(node, identifier.getParentResourceId());
        }
        this.batchNode(node);
        this.progressMonitor.stopJob(node);
    }

    private void setNodeIds(ProfileResourceNode node, ResourceId parentId) {
        node.setId(this.nodeIdValue.getAndIncrement());
        Long nodeId = node.getId();
        String nodePrefix = ResourceUtils.getBase128Integer((long)nodeId);
        String nodePrefixPlusOne = ResourceUtils.getBase128Integer((long)(nodeId + 1L));
        String parentsPrefixString = "";
        if (parentId != null) {
            parentsPrefixString = parentId.getPath();
            node.setParentId(parentId.getId());
        }
        node.setPrefix(parentsPrefixString + nodePrefix);
        node.setPrefixPlusOne(parentsPrefixString + nodePrefixPlusOne);
    }

    private void batchNode(ProfileResourceNode node) {
        this.batchedNodes.add(node);
        if (this.nodeIdValue.get() % (long)this.batchSize == 0L) {
            this.commit();
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ProfileResourceNode loadNode(Long nodeId) {
        return (ProfileResourceNode)this.entityManager.find(ProfileResourceNode.class, (Object)nodeId);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Format loadFormat(String puid) {
        return (Format)this.entityManager.find(Format.class, (Object)puid);
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void deleteCascade(Long nodeId) {
        this.deleteNode(nodeId);
    }

    public void setEntityManagerFactory(EntityManagerFactory factory) {
        this.entityManagerFactory = factory;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteNode(Long nodeId) {
        ProfileResourceNode node = (ProfileResourceNode)this.entityManager.getReference(ProfileResourceNode.class, (Object)nodeId);
        this.log.warn((Object)String.format("Deleting Node [%s]", node.getUri()));
        String nodesToRemove = "from ProfileResourceNode n  where n.prefix >= ?  and n.prefix < ? ";
        Query q = this.entityManager.createQuery(nodesToRemove);
        q.setParameter(1, (Object)node.getPrefix());
        q.setParameter(2, (Object)node.getPrefixPlusOne());
        for (Object o : q.getResultList()) {
            this.entityManager.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        try {
            EntityManager em = this.entityManagerFactory.createEntityManager();
            em.getTransaction().begin();
            List<ProfileResourceNode> list = this.batchedNodes;
            synchronized (list) {
                for (ProfileResourceNode node : this.batchedNodes) {
                    em.persist((Object)node);
                }
                this.batchedNodes.clear();
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (RuntimeException ex) {
            this.log.error((Object)ex);
        }
    }
}

