/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.results.handlers;

import java.net.URI;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationErrorType;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.results.handlers.ProgressMonitor;
import uk.gov.nationalarchives.droid.results.handlers.ResultHandlerDao;

public class ResultHandlerImpl
implements ResultHandler {
    private Log log = LogFactory.getLog(this.getClass());
    private ResultHandlerDao resultHandlerDao;
    private ProgressMonitor progressMonitor;

    @Transactional(propagation=Propagation.REQUIRED)
    public ResourceId handle(IdentificationResultCollection results) {
        ProfileResourceNode node = new ProfileResourceNode(results.getUri());
        RequestMetaData requestMetaData = results.getRequestMetaData();
        NodeMetaData metaData = new NodeMetaData();
        metaData.setLastModified(requestMetaData.getTime());
        metaData.setSize(results.getFileLength());
        metaData.setName(requestMetaData.getName());
        metaData.setExtension(ResourceUtils.getExtension((String)requestMetaData.getName()));
        metaData.setResourceType(results.isArchive() ? ResourceType.CONTAINER : ResourceType.FILE);
        metaData.setHash(requestMetaData.getHash());
        metaData.setNodeStatus(NodeStatus.DONE);
        node.setMetaData(metaData);
        node.setExtensionMismatch(results.getExtensionMismatch());
        node.setFinished(new Date());
        ResourceId parentId = results.getCorrelationId();
        this.resultHandlerDao.save(node, parentId);
        if (results.getResults().isEmpty()) {
            node.addFormatIdentification(Format.NULL);
            node.setZeroIdentifications();
        } else {
            for (IdentificationResult result : results.getResults()) {
                node.getMetaData().setIdentificationMethod(result.getMethod());
                Format format = this.resultHandlerDao.loadFormat(result.getPuid());
                node.addFormatIdentification(format);
            }
        }
        this.progressMonitor.stopJob(node);
        return new ResourceId(node.getId().longValue(), node.getPrefix());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void handleError(IdentificationException e) {
        ProfileResourceNode node;
        IdentificationRequest request = e.getRequest();
        RequestIdentifier identifier = request.getIdentifier();
        URI uri = identifier.getUri();
        Long nodeId = identifier.getNodeId();
        if (nodeId != null) {
            node = this.resultHandlerDao.loadNode(nodeId);
            node.getMetaData().setNodeStatus(NodeStatus.ERROR);
            node.getFormatIdentifications().size();
        } else {
            node = new ProfileResourceNode(uri);
            node.setFinished(new Date());
            NodeMetaData metaData = node.getMetaData();
            metaData.setNodeStatus(this.getNodeStatus(e.getErrorType()));
            metaData.setResourceType(ResourceType.FILE);
            node.setNoFormatsIdentified();
            RequestMetaData requestMetaData = request.getRequestMetaData();
            metaData.setName(requestMetaData.getName());
            metaData.setSize(requestMetaData.getSize());
            metaData.setExtension(request.getExtension());
            metaData.setLastModified(request.getRequestMetaData().getTime());
            metaData.setHash(requestMetaData.getHash());
            node.addFormatIdentification(Format.NULL);
            this.resultHandlerDao.save(node, identifier.getParentResourceId());
        }
        this.progressMonitor.stopJob(node);
    }

    private NodeStatus getNodeStatus(IdentificationErrorType error) {
        NodeStatus status;
        switch (error) {
            case ACCESS_DENIED: {
                status = NodeStatus.ACCESS_DENIED;
                break;
            }
            case FILE_NOT_FOUND: {
                status = NodeStatus.NOT_FOUND;
                break;
            }
            default: {
                status = NodeStatus.ERROR;
            }
        }
        return status;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ResourceId handleDirectory(IdentificationResult result, ResourceId parentId, boolean restricted) {
        URI uri = result.getIdentifier().getUri();
        ProfileResourceNode node = new ProfileResourceNode(uri);
        RequestMetaData requestMetaData = result.getMetaData();
        NodeMetaData metaData = new NodeMetaData();
        metaData.setName(requestMetaData.getName());
        metaData.setSize(null);
        metaData.setLastModified(requestMetaData.getTime());
        metaData.setIdentificationMethod(IdentificationMethod.NULL);
        metaData.setNodeStatus(restricted ? NodeStatus.ACCESS_DENIED : NodeStatus.DONE);
        metaData.setResourceType(ResourceType.FOLDER);
        node.setMetaData(metaData);
        this.resultHandlerDao.save(node, parentId);
        node.setFinished(new Date());
        node.addFormatIdentification(Format.NULL);
        this.progressMonitor.stopJob(node);
        return new ResourceId(node.getId().longValue(), node.getPrefix());
    }

    public void setResultHandlerDao(ResultHandlerDao resultHandlerDao) {
        this.resultHandlerDao = resultHandlerDao;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void deleteCascade(Long nodeId) {
        this.resultHandlerDao.deleteNode(nodeId);
    }

    public void commit() {
    }

    public void init() {
    }
}

