/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.signature;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ErrorCode;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.signature.FormatCallback;
import uk.gov.nationalarchives.droid.signature.SignatureParser;

public class SaxSignatureFileParser
implements SignatureParser {
    private static final String INVALID_SIGNATURE_FILE = "Invalid signature file [%s]";
    private Log log = LogFactory.getLog(this.getClass());
    private File file;

    public SaxSignatureFileParser(URI filePath) throws SignatureFileException {
        this.file = this.openFile(filePath);
    }

    @Override
    public void formats(FormatCallback callback) throws SignatureFileException {
        FileFormatHandler handler = new FileFormatHandler(callback);
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxParserFactory.newSAXParser();
            saxParser.parse(this.file, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new SignatureFileException(String.format(INVALID_SIGNATURE_FILE, this.file.toURI()), (Throwable)e, ErrorCode.INVALID_SIGNATURE_FILE);
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.log.error((Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private File openFile(URI filePath) throws SignatureFileException {
        File f = new File(filePath);
        if (!f.exists()) {
            throw new SignatureFileException(String.format("Signature file does not exist [%s]", filePath), ErrorCode.FILE_NOT_FOUND);
        }
        if (!f.isFile()) {
            throw new SignatureFileException(String.format(INVALID_SIGNATURE_FILE, filePath), ErrorCode.INVALID_SIGNATURE_FILE);
        }
        return f;
    }

    private static final class FileFormatHandler
    extends DefaultHandler {
        private FormatCallback callback;

        public FileFormatHandler(FormatCallback callback) {
            this.callback = callback;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("FileFormat".equals(qName)) {
                Format format = new Format();
                format.setPuid(this.notNull(attributes.getValue("PUID")));
                format.setName(this.notNull(attributes.getValue("Name")));
                format.setMimeType(this.notNull(attributes.getValue("MIMEType")));
                format.setVersion(this.notNull(attributes.getValue("Version")));
                this.callback.onFormat(format);
            }
        }

        private String notNull(String value) {
            return value == null ? "" : value;
        }
    }
}

