/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.list.TransformedList;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.submitter.FileWalkerHandler;
import uk.gov.nationalarchives.droid.submitter.SubmitterUtils;

@XmlAccessorType(value=XmlAccessType.NONE)
public class FileWalker
extends DirectoryWalker {
    private static final String FILE_SYSTEM_UNAVAILABLE = "File system appears to be unavailable for file: [%s]";
    private static final Transformer FILE_TO_URI_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            return ((File)input).toURI();
        }
    };
    @XmlTransient
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    @XmlElement(name="RootUri")
    private URI root;
    @XmlAttribute(name="Recursive")
    private boolean recursive;
    @XmlElementWrapper(name="Progress")
    @XmlElement(name="ProgressEntry")
    private Deque<ProgressEntry> progress;
    private FileWalkerHandler fileHandler;
    private FileWalkerHandler directoryHandler;
    private FileWalkerHandler restrictedDirectoryHandler;
    private boolean fastForward;
    private List<ProgressEntry> recoveryRoad;

    FileWalker() {
    }

    public FileWalker(URI root, boolean recursive) {
        super(null, recursive ? -1 : 1);
        this.recursive = recursive;
        this.root = root;
    }

    public void walk() throws IOException {
        if (this.progress != null) {
            this.fastForward = true;
            this.recoveryRoad = FileWalker.reverseProgress(this.progress);
        } else {
            this.progress = new ArrayDeque<ProgressEntry>();
        }
        this.walk(new File(this.root), null);
    }

    private static List<ProgressEntry> reverseProgress(Deque<ProgressEntry> progress) {
        ArrayList<ProgressEntry> reversed = new ArrayList<ProgressEntry>();
        Iterator<ProgressEntry> it = progress.descendingIterator();
        while (it.hasNext()) {
            ProgressEntry entry = it.next();
            reversed.add(entry);
        }
        return reversed;
    }

    protected void handleFile(File file, int depth, Collection results) throws IOException {
        if (!SubmitterUtils.isFileSystemAvailable(file, this.root)) {
            this.log.error((Object)String.format(FILE_SYSTEM_UNAVAILABLE, file.getAbsolutePath()));
            throw new IOException(file.getAbsolutePath());
        }
        if (this.fastForward) {
            if (this.recoveryRoad.get(depth - 1).containsChild(file.toURI())) {
                this.fastForward = false;
            } else {
                return;
            }
        }
        ProgressEntry progressEntry = this.progress.peek();
        if (file.isFile()) {
            this.fileHandler.handle(file, depth, progressEntry);
        }
        progressEntry.removeChild(file.toURI());
    }

    protected boolean handleDirectory(File dir, int depth, Collection results) throws IOException {
        boolean processDir = true;
        if (!SubmitterUtils.isFileSystemAvailable(dir, this.root)) {
            this.log.error((Object)String.format(FILE_SYSTEM_UNAVAILABLE, dir.getAbsolutePath()));
            throw new IOException(dir.getAbsolutePath());
        }
        URI dirUri = dir.toURI();
        if (this.fastForward && (depth >= this.recoveryRoad.size() || !this.recoveryRoad.get(depth).getUri().equals(dirUri))) {
            if (this.recoveryRoad.get(depth - 1).containsChild(dirUri)) {
                this.fastForward = false;
            } else {
                processDir = false;
            }
        }
        return processDir;
    }

    protected void handleDirectoryStart(File directory, int depth, Collection results) throws IOException {
        ResourceId directoryId;
        if (this.fastForward) {
            return;
        }
        ProgressEntry parent = this.progress.peek();
        List unprocessedChildren = Collections.EMPTY_LIST;
        if (this.recursive || depth == 0) {
            File[] children = directory.listFiles();
            if (children == null) {
                directoryId = this.restrictedDirectoryHandler.handle(directory, depth, parent);
            } else {
                unprocessedChildren = TransformedList.decorate(new ArrayList(), (Transformer)FILE_TO_URI_TRANSFORMER);
                unprocessedChildren.addAll(Arrays.asList(children));
                directoryId = this.directoryHandler.handle(directory, depth, parent);
            }
        } else {
            directoryId = this.directoryHandler.handle(directory, depth, parent);
        }
        this.progress.push(new ProgressEntry(directory.toURI(), directoryId, unprocessedChildren));
    }

    protected void handleDirectoryEnd(File directory, int depth, Collection results) {
        if (this.fastForward) {
            this.fastForward = false;
            while (this.progress.size() - 1 > depth) {
                this.progress.pop();
            }
        }
        this.progress.pop();
        if (!this.progress.isEmpty()) {
            this.progress.peek().removeChild(directory.toURI());
        }
    }

    public void setFileHandler(FileWalkerHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void setDirectoryHandler(FileWalkerHandler directoryHandler) {
        this.directoryHandler = directoryHandler;
    }

    public void setRestrictedDirectoryHandler(FileWalkerHandler restrictedDirectoryHandler) {
        this.restrictedDirectoryHandler = restrictedDirectoryHandler;
    }

    Deque<ProgressEntry> progress() {
        return this.progress;
    }

    void setProgress(Deque<ProgressEntry> progress) {
        this.progress = progress;
    }

    public static final class ProgressEntry {
        @XmlAttribute(name="Id")
        private long id;
        @XmlAttribute(name="Prefix")
        private String prefix;
        @XmlElement(name="Uri")
        private URI uri;
        @XmlElementWrapper(name="Children")
        @XmlElement(name="ChildUri")
        private List<URI> children;

        ProgressEntry() {
        }

        ProgressEntry(URI uri, long id, String prefix, List<URI> children) {
            this.uri = uri;
            this.id = id;
            this.prefix = prefix;
            this.children = children;
        }

        ProgressEntry(URI uri, ResourceId resourceId, List<URI> children) {
            if (resourceId == null) {
                throw new IllegalArgumentException("Cannot construct a ProgressEntry with a null ResourceId");
            }
            this.uri = uri;
            this.id = resourceId.getId();
            this.prefix = resourceId.getPath();
            this.children = children;
        }

        public long getId() {
            return this.id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public ResourceId getResourceId() {
            return new ResourceId(this.id, this.prefix);
        }

        public URI getUri() {
            return this.uri;
        }

        private void removeChild(URI childUri) {
            this.children.remove(childUri);
        }

        public boolean containsChild(URI childUri) {
            return this.children != null && this.children.contains(childUri);
        }
    }
}

