/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.DroidCore;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationErrorType;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFormatResolver;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandlerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ContainerIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ContainerIdentifierFactory;
import uk.gov.nationalarchives.droid.core.interfaces.control.PauseBefore;
import uk.gov.nationalarchives.droid.core.interfaces.hash.HashGenerator;
import uk.gov.nationalarchives.droid.submitter.JobCounter;
import uk.gov.nationalarchives.droid.submitter.ReplaySubmitter;
import uk.gov.nationalarchives.droid.submitter.SubmissionQueue;

public class SubmissionGateway
implements AsynchDroid {
    private static final String CONTAINER_ERROR = "Could not process the potential container format (%s): %s\t%s\t%s";
    private static final String ARCHIVE_ERROR = "Could not process the archival format(%s): %s\t%s\t%s";
    private final Log log = LogFactory.getLog(this.getClass());
    private DroidCore droidCore;
    private ResultHandler resultHandler;
    private ExecutorService executorService;
    private boolean processArchives;
    private ArchiveFormatResolver archiveFormatResolver;
    private ArchiveFormatResolver containerFormatResolver;
    private ArchiveHandlerFactory archiveHandlerFactory;
    private ContainerIdentifierFactory containerIdentifierFactory;
    private HashGenerator hashGenerator;
    private String hashAlgorithm;
    private boolean generateHash;
    private boolean matchAllExtensions;
    private long maxBytesToScan = -1L;
    private SubmissionQueue submissionQueue;
    private final JobCounter jobCounter = new JobCounter();
    private ReplaySubmitter replaySubmitter;
    private Set<IdentificationRequest> requests = new HashSet<IdentificationRequest>();

    @PauseBefore
    public Future<IdentificationResultCollection> submit(final IdentificationRequest request) {
        this.jobCounter.increment();
        this.requests.add(request);
        Callable<IdentificationResultCollection> callable = new Callable<IdentificationResultCollection>(){

            @Override
            public IdentificationResultCollection call() throws IOException {
                SubmissionGateway.this.droidCore.setMaxBytesToScan(SubmissionGateway.this.maxBytesToScan);
                IdentificationResultCollection results = SubmissionGateway.this.droidCore.matchBinarySignatures(request);
                return results;
            }
        };
        SubmissionFutureTask task = new SubmissionFutureTask(callable, request);
        this.executorService.submit(task);
        return task;
    }

    public void replay() {
        this.replaySubmitter.replay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHash(IdentificationRequest request) throws IOException {
        if (this.generateHash) {
            try {
                InputStream in = request.getSourceInputStream();
                try {
                    String hash = this.hashGenerator.hash(in);
                    request.getRequestMetaData().setHash(hash);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
    }

    private IdentificationResultCollection handleExtensions(IdentificationRequest request, IdentificationResultCollection results) {
        IdentificationResultCollection extensionResults = results;
        try {
            List resultList = results.getResults();
            if (resultList != null && resultList.isEmpty()) {
                IdentificationResultCollection checkExtensionResults = this.droidCore.matchExtensions(request, this.matchAllExtensions);
                if (checkExtensionResults != null) {
                    extensionResults = checkExtensionResults;
                }
            } else {
                this.droidCore.checkForExtensionsMismatches(extensionResults, request.getExtension());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return extensionResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleArchive(IdentificationRequest request, IdentificationResultCollection results) {
        boolean jobCountDecremented = false;
        String archiveFormat = this.getArchiveFormat(results);
        if (archiveFormat != null) {
            results.setArchive(true);
            ResourceId id = this.resultHandler.handle(results);
            this.jobCounter.incrementPostProcess();
            RequestIdentifier identifier = request.getIdentifier();
            identifier.setResourceId(id);
            if (identifier.getAncestorId() == null) {
                identifier.setAncestorId(Long.valueOf(id.getId()));
            }
            this.submissionQueue.add(request.getIdentifier());
            this.jobCounter.decrement();
            jobCountDecremented = true;
            try {
                ArchiveHandler handler = this.archiveHandlerFactory.getHandler(archiveFormat);
                handler.handle(request);
            }
            catch (Exception e) {
                String causeMessage = "";
                if (e.getCause() != null) {
                    causeMessage = e.getCause().getMessage();
                }
                String message = String.format(ARCHIVE_ERROR, archiveFormat, request.getIdentifier().getUri().toString(), e.getMessage(), causeMessage);
                this.log.warn((Object)message);
                this.resultHandler.handleError(new IdentificationException(request, IdentificationErrorType.OTHER, (Throwable)e));
            }
            finally {
                this.submissionQueue.remove(request.getIdentifier());
                this.jobCounter.decrementPostProcess();
            }
        } else {
            ResourceId id = this.resultHandler.handle(results);
            request.getIdentifier().setNodeId(Long.valueOf(id.getId()));
        }
        return jobCountDecremented;
    }

    private IdentificationResultCollection handleContainer(IdentificationRequest request, IdentificationResultCollection results) throws IOException {
        String containerFormat = this.getContainerFormat(results);
        try {
            if (this.containerFormatResolver != null && containerFormat != null) {
                ContainerIdentifier containerIdentifier = this.containerIdentifierFactory.getIdentifier(containerFormat);
                containerIdentifier.setMaxBytesToScan(this.maxBytesToScan);
                IdentificationResultCollection containerResults = containerIdentifier.submit(request);
                this.droidCore.removeLowerPriorityHits(containerResults);
                this.droidCore.checkForExtensionsMismatches(containerResults, request.getExtension());
                containerResults.setFileLength(Long.valueOf(request.size()));
                containerResults.setRequestMetaData(request.getRequestMetaData());
                return containerResults.getResults().isEmpty() ? null : containerResults;
            }
        }
        catch (Exception e) {
            String causeMessage = "";
            if (e.getCause() != null) {
                causeMessage = e.getCause().getMessage();
            }
            String message = String.format(CONTAINER_ERROR, containerFormat, request.getIdentifier().getUri().toString(), e.getMessage(), causeMessage);
            this.log.warn((Object)message);
        }
        return null;
    }

    private String getArchiveFormat(IdentificationResultCollection results) {
        for (IdentificationResult result : results.getResults()) {
            String format = this.archiveFormatResolver.forPuid(result.getPuid());
            if (format == null) continue;
            return format;
        }
        return null;
    }

    private String getContainerFormat(IdentificationResultCollection results) {
        for (IdentificationResult result : results.getResults()) {
            String format = this.containerFormatResolver.forPuid(result.getPuid());
            if (format == null) continue;
            return format;
        }
        return null;
    }

    public void awaitIdle() throws InterruptedException {
        this.jobCounter.awaitIdle();
    }

    public void awaitFinished() throws InterruptedException {
        this.jobCounter.awaitFinished();
    }

    public void setArchiveFormatResolver(ArchiveFormatResolver archiveFormatResolver) {
        this.archiveFormatResolver = archiveFormatResolver;
    }

    public void setArchiveHandlerFactory(ArchiveHandlerFactory archiveHandlerFactory) {
        this.archiveHandlerFactory = archiveHandlerFactory;
    }

    public void setContainerFormatResolver(ArchiveFormatResolver containerFormatResolver) {
        this.containerFormatResolver = containerFormatResolver;
    }

    public void setContainerIdentifierFactory(ContainerIdentifierFactory containerIdentifierFactory) {
        this.containerIdentifierFactory = containerIdentifierFactory;
    }

    public void setDroidCore(DroidCore droidCore) {
        this.droidCore = droidCore;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setProcessArchives(boolean processArchives) {
        this.processArchives = processArchives;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void setSubmissionQueue(SubmissionQueue submissionQueue) {
        this.submissionQueue = submissionQueue;
    }

    public void save() {
        this.resultHandler.commit();
        this.submissionQueue.save();
    }

    public void setReplaySubmitter(ReplaySubmitter replaySubmitter) {
        this.replaySubmitter = replaySubmitter;
    }

    public void setHashGenerator(HashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public void setGenerateHash(boolean generateHash) {
        this.generateHash = generateHash;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public void close() throws IOException {
        this.executorService.shutdownNow();
        for (IdentificationRequest request : this.requests) {
            request.close();
        }
    }

    public void setMaxBytesToScan(long maxBytesToScan) {
        this.maxBytesToScan = maxBytesToScan;
    }

    public void setMatchAllExtensions(boolean matchAllExtensions) {
        this.matchAllExtensions = matchAllExtensions;
    }

    private final class SubmissionFutureTask
    extends FutureTask<IdentificationResultCollection> {
        private IdentificationRequest request;

        SubmissionFutureTask(Callable<IdentificationResultCollection> callable, IdentificationRequest request) {
            super(callable);
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            boolean jobCountDecremented = false;
            try {
                SubmissionGateway.this.generateHash(this.request);
                IdentificationResultCollection results = (IdentificationResultCollection)this.get();
                IdentificationResultCollection containerResults = SubmissionGateway.this.handleContainer(this.request, results);
                if (containerResults == null) {
                    SubmissionGateway.this.droidCore.removeLowerPriorityHits(results);
                    results = SubmissionGateway.this.handleExtensions(this.request, results);
                    if (SubmissionGateway.this.processArchives && SubmissionGateway.this.archiveFormatResolver != null) {
                        jobCountDecremented = SubmissionGateway.this.handleArchive(this.request, results);
                    } else {
                        results.setArchive(SubmissionGateway.this.getArchiveFormat(results) != null);
                        ResourceId id = SubmissionGateway.this.resultHandler.handle(results);
                        this.request.getIdentifier().setResourceId(id);
                    }
                } else {
                    SubmissionGateway.this.droidCore.removeLowerPriorityHits(containerResults);
                    containerResults = SubmissionGateway.this.handleExtensions(this.request, containerResults);
                    ResourceId id = SubmissionGateway.this.resultHandler.handle(containerResults);
                    this.request.getIdentifier().setResourceId(id);
                }
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                SubmissionGateway.this.log.error((Object)cause.getStackTrace(), cause);
                SubmissionGateway.this.resultHandler.handleError(new IdentificationException(this.request, IdentificationErrorType.OTHER, cause));
            }
            catch (InterruptedException e) {
                SubmissionGateway.this.log.debug((Object)e);
            }
            catch (IOException e) {
                SubmissionGateway.this.resultHandler.handleError(new IdentificationException(this.request, IdentificationErrorType.OTHER, (Throwable)e));
            }
            finally {
                this.closeRequest();
                if (!jobCountDecremented) {
                    SubmissionGateway.this.jobCounter.decrement();
                }
            }
        }

        private void closeRequest() {
            SubmissionGateway.this.requests.remove(this.request);
            try {
                this.request.close();
            }
            catch (IOException e) {
                SubmissionGateway.this.log.error((Object)String.format("Error closing request [%s]", this.request.getIdentifier().getUri()), (Throwable)e);
            }
        }
    }
}

