/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.StringUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public abstract class MetadataElementDefaultExpressions {
    private static final String DATE_NAME_REGEX = "(?<date>(?<year>^\\d{4})((_(?<month>\\d{2}))(_(?<day>\\d{2}))?)?)(_|$)(?<title>[^_]+)?(_(?<notes>.+))?";
    private static final String INPUT_DATE_FORMAT = "yyyy_MM_dd";
    private static final String OUTPUT_DATE_FORMAT = "d.M.yyyy";

    public static String getUniqueNumericValueWithParentsPrefix(NodeAbstract context, MetadataElement metadataElement) throws Exception {
        String returnValue = null;
        if (context.isRoot().booleanValue()) {
            returnValue = "1";
        } else {
            NodeFolder parent = (NodeFolder)context.getParent();
            String prefix = parent.getDynamicMetadataValueForName(metadataElement.getAccessorName()) + "/";
            for (MutableTreeTableNode child : ((NodeFolder)context.getParent()).getChildren()) {
                if (child == context) continue;
                if (returnValue == null) {
                    returnValue = ((NodeAbstract)child).getDynamicMetadataValueForName(metadataElement.getAccessorName());
                    continue;
                }
                String value = ((NodeAbstract)child).getDynamicMetadataValueForName(metadataElement.getAccessorName());
                int comparison = value.compareTo(returnValue);
                returnValue = comparison > 0 ? value : returnValue;
            }
            if (returnValue == null) {
                returnValue = prefix + "1";
            } else {
                if (!returnValue.startsWith(prefix)) {
                    returnValue = prefix + returnValue;
                }
                returnValue = StringUtil.increment((String)returnValue);
            }
        }
        return returnValue;
    }

    public static String extractDateFromFilename(NodeAbstract context) throws Exception {
        Pattern p;
        Matcher m;
        String result = null;
        String fileName = context.getLabel();
        if (fileName != null && (m = (p = Pattern.compile(DATE_NAME_REGEX)).matcher(fileName)).find()) {
            String datePart = m.group("date");
            int dateLength = datePart.length();
            String year = m.group("year");
            String month = null;
            if (m.group("month") != null) {
                month = m.group("month").replaceFirst("^0", "");
            }
            switch (dateLength) {
                case 10: {
                    DateTimeFormatter inputFormat = DateTimeFormatter.ofPattern(INPUT_DATE_FORMAT);
                    try {
                        LocalDate date = LocalDate.parse(datePart, inputFormat);
                        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern(OUTPUT_DATE_FORMAT);
                        result = date.format(outputFormatter);
                        if (date.format(inputFormat).equals(datePart)) break;
                        Logger.getLogger().warn("The date string '" + datePart + "' will be parsed as '" + result + "'");
                    }
                    catch (DateTimeParseException e) {
                        result = Integer.parseInt(month) < 13 ? month + "." + year : year;
                        Logger.getLogger().warn("The date string '" + datePart + "'  will be parsed as '" + result + "'");
                    }
                    break;
                }
                case 7: {
                    if (Integer.parseInt(month) < 13) {
                        result = month + "." + year;
                        break;
                    }
                    Logger.getLogger().warn("The month " + month + " is not valid and only the year " + year + " will be used.");
                    result = year;
                    break;
                }
                case 4: {
                    result = datePart;
                }
            }
        }
        if (result == null) {
            throw new Exception("No date for filename " + fileName);
        }
        return result;
    }

    public static String extractTitleFromFilename(NodeAbstract context) throws Exception {
        return MetadataElementDefaultExpressions.extractPartOfFileName(context, "title");
    }

    public static String extractNotesFromFilename(NodeAbstract context) throws Exception {
        return MetadataElementDefaultExpressions.extractPartOfFileName(context, "notes");
    }

    private static String extractPartOfFileName(NodeAbstract context, String partLabel) {
        Pattern p;
        Matcher m;
        String result = null;
        String fileName = FileUtil.asFileNameWithoutExtension((String)context.getLabel());
        if (fileName != null && (m = (p = Pattern.compile(DATE_NAME_REGEX)).matcher(fileName)).find()) {
            result = m.group(partLabel);
        }
        return result;
    }
}

