/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.structmap;

import bsh.EvalError;
import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.FolderNameIsEmptyException;
import ch.docuteam.darc.exceptions.LevelMetadataElementIsReadOnly;
import ch.docuteam.darc.exceptions.MetadataElementAllowedValuesException;
import ch.docuteam.darc.exceptions.MetadataElementCantDeleteException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.exceptions.NodeFileDeletionNotAllowedException;
import ch.docuteam.darc.mdconfig.MetadataElementInstance;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.amdsec.DigiprovWithPremis;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.darc.mets.structmap.StructureMap;
import ch.docuteam.darc.premis.Event;
import ch.docuteam.darc.premis.Object;
import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.tools.exception.Exception;
import ch.docuteam.tools.file.FileChecksumCalculator;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public class NodeFile
extends NodeAbstract {
    public static final String NO_MIME_TYPE_FOUND_EXCEPTION = "NoMimeTypeFoundExceptionMessage";
    public static final String NO_FORMAT_ID_FOUND_EXCEPTION = "NoFormatIDFoundExceptionMessage";
    protected static final String Type = "file";
    protected static final String RootType = "rootfile";
    protected static final String DivLabel = "Content";
    protected static final String DivType = "content";
    protected String fileId;
    protected Long size = 0L;
    protected boolean isAllowedBySA = true;

    protected NodeFile(StructureMap parent, Element element) {
        super(parent.getDocument(), element);
        this.initialize();
    }

    protected NodeFile(NodeFolder parent, Element element) {
        super(parent.getDocument(), element);
        parent.add((MutableTreeTableNode)this);
        this.initialize();
    }

    protected NodeFile(NodeFolder parent, ch.docuteam.darc.mets.filesec.File file) {
        this(parent, file, null);
        this.initializeFileAccessRights();
    }

    protected NodeFile(NodeFolder parent, ch.docuteam.darc.mets.filesec.File file, String reuseExistingAdmId) {
        super(parent, file.getFile().getName());
        if (reuseExistingAdmId != null) {
            this.admId = reuseExistingAdmId;
        }
        this.allowsChildren = false;
        this.type = Type;
        this.fileId = file.getId();
        this.size = file.getFile().length();
        this.element = ((NodeFolder)this.parent).getElement().addElement("METS:div").addAttribute("LABEL", this.label).addAttribute("TYPE", this.type).addAttribute("ADMID", this.admId);
        Element intermediaryDiv = this.element.addElement("METS:div").addAttribute("LABEL", DivLabel).addAttribute("TYPE", DivType);
        intermediaryDiv.addElement("METS:fptr").addAttribute("FILEID", this.fileId);
        if (reuseExistingAdmId == null) {
            new DigiprovWithPremis(this);
        }
        this.createDMDSectionWithEADIfNecessary();
        try {
            this.setLevel(parent.getLevel().getDefaultSubLevel());
        }
        catch (java.lang.Exception e) {
            e.printStackTrace();
        }
        this.initializeDynamicMetadataElementInstancesWhichAreMandatoryOrAlwaysDisplayed();
    }

    protected NodeFile(StructureMap parent, ch.docuteam.darc.mets.filesec.File file) {
        super(parent, file.getFile().getName());
        this.allowsChildren = false;
        this.type = RootType;
        this.fileId = file.getId();
        this.size = file.getFile().length();
        this.element = parent.getElement().addElement("METS:div").addAttribute("LABEL", this.label).addAttribute("TYPE", this.type).addAttribute("ADMID", this.admId);
        Element intermediaryDiv = this.element.addElement("METS:div").addAttribute("LABEL", DivLabel).addAttribute("TYPE", DivType);
        intermediaryDiv.addElement("METS:fptr").addAttribute("FILEID", this.fileId);
        new DigiprovWithPremis(this);
        this.createDMDSectionWithEADIfNecessary();
        this.initializeDynamicMetadataElementInstancesWhichAreMandatoryOrAlwaysDisplayed();
    }

    public String getFileId() {
        return this.fileId;
    }

    @Override
    public String getChecksum() {
        return this.getMyLastDigiprovObject().getMessageDigest();
    }

    @Override
    public String getChecksumType() {
        return this.getMyLastDigiprovObject().getMessageDigestAlgorithm();
    }

    @Override
    public String getMimeType() {
        return this.getMyFileSectionFile().getMimeType();
    }

    @Override
    public String getFormatKey() {
        return this.getMyLastDigiprovObject().getFormatRegistryKey();
    }

    @Override
    public String getFormatName() {
        return this.getMyLastDigiprovObject().getFormatName();
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public int getDescendantCount() {
        return 0;
    }

    @Override
    public List<NodeAbstract> getWithDescendants() {
        ArrayList<NodeAbstract> all = new ArrayList<NodeAbstract>();
        all.add(this);
        return all;
    }

    @Override
    public List<NodeAbstract> getWithDescendantsDepthFirst() {
        return this.getWithDescendants();
    }

    @Override
    public int getTreeDepth() {
        return 0;
    }

    public void setIsNotAllowedBySA() {
        this.isAllowedBySA = false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean checkFixity() {
        String filePath = this.getAbsolutePathString();
        Logger.getLogger().info("Fixity Check: " + filePath + "... ");
        if (!this.isPartOfSubmission()) {
            Logger.getLogger().debug("Skipped because not part of submission");
            return true;
        }
        String docType = ((Document)this.document).getType();
        try {
            if (!FileChecksumCalculator.Algorithm.lookup((String)this.getChecksumType()).getDigest(filePath).equalsIgnoreCase(this.getChecksum())) {
                this.createNewEvent("Fixity Check", "Based on " + docType, "Failure", "Calculated checksum differs from stored checksum");
                Logger.getLogger().warn("Checksum verification failed on file: " + filePath);
                Exception.remember((String)("Checksum verification failed on file: " + filePath));
                return false;
            }
            this.createNewEvent("Fixity Check", "Based on " + docType, "Success", "");
        }
        catch (FileNotFoundException e) {
            this.createNewEvent("Fixity Check", "Based on " + docType, "Failure", e.getMessage());
            Logger.getLogger().error((java.lang.Object)e);
            Exception.remember((Throwable)e);
            return false;
        }
        catch (IOException e) {
            this.createNewEvent("Fixity Check", "Based on " + docType, "Failure", e.getMessage());
            Logger.getLogger().error((java.lang.Object)e);
            Exception.remember((Throwable)e);
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            this.createNewEvent("Fixity Check", "Based on " + docType, "Failure", e.getMessage());
            Logger.getLogger().error((java.lang.Object)e);
            Exception.remember((Throwable)e);
            return false;
        }
        Logger.getLogger().info("Checksum OK for file: " + filePath);
        return true;
    }

    @Override
    public boolean checkAgainstSubmissionAgreement() {
        return this.checkAgainstSubmissionAgreement(((Document)this.document).getSubmissionAgreement(), ((Document)this.document).getDSSId());
    }

    @Override
    public List<NodeFile> filesNotAllowedBySubmissionAgreement() {
        return this.filesNotAllowedBySubmissionAgreement(((Document)this.document).getSubmissionAgreement(), ((Document)this.document).getDSSId());
    }

    @Override
    public boolean checkAgainstSubmissionAgreement(SubmissionAgreement sa, String dssId) {
        return sa.allowsFileType(dssId, this.getAbsolutePathString(), this.getFormatKey(), this.getMimeType());
    }

    @Override
    public List<NodeFile> filesNotAllowedBySubmissionAgreement(SubmissionAgreement sa, String dssId) {
        Vector<NodeFile> result = new Vector<NodeFile>();
        if (!this.checkAgainstSubmissionAgreement(sa, dssId)) {
            result.add(this);
        }
        return result;
    }

    @Override
    public boolean isAllowedBySA() {
        return this.isAllowedBySA;
    }

    @Override
    public boolean hasMimeType() {
        String mimeType = this.getMimeType();
        return mimeType == null || mimeType.isEmpty();
    }

    @Override
    public boolean hasFormatKey() {
        String formatKey = this.getFormatKey();
        return formatKey == null || formatKey.isEmpty();
    }

    @Override
    public NodeAbstract searchId(String admId) {
        return this.admId.equals(admId) ? this : null;
    }

    @Override
    public List<NodeAbstract> searchLabel(String label) {
        ArrayList<NodeAbstract> found = new ArrayList<NodeAbstract>(1);
        if (this.label.equals(label)) {
            found.add(this);
        }
        return found;
    }

    @Override
    public NodeAbstract searchFileId(String fileId) {
        return this.fileId.equals(fileId) ? this : null;
    }

    @Override
    public void rename(String label) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException {
        this.checkIfFileOperationNotAllowed(label, "Rename");
        String oldAbsolutePath = this.getAbsolutePathString();
        super.rename(label);
        String newAbsolutePath = this.getAbsolutePathString();
        this.getMyFileSectionFile().rename(this.getPathString());
        FileUtil.renameTo((String)oldAbsolutePath, (String)newAbsolutePath);
    }

    @Override
    public void moveTo(NodeFolder toFolder) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException {
        this.checkIfFileOperationNotAllowed(toFolder.label, "Move");
        String oldAbsolutePath = this.getAbsolutePathString();
        super.moveTo(toFolder);
        String newAbsolutePath = this.getAbsolutePathString();
        this.getMyFileSectionFile().moveTo(toFolder);
        FileUtil.renameTo((String)oldAbsolutePath, (String)newAbsolutePath);
    }

    @Override
    public void moveBeforeNode(NodeAbstract node) throws FileOperationNotAllowedException, IOException, FileAlreadyExistsException {
        this.checkIfFileOperationNotAllowed(node.label, "MoveBeforeNode");
        String oldRelativePath = this.getPathString();
        String oldAbsolutePath = this.getAbsolutePathString();
        super.moveBeforeNode(node);
        String newRelativePath = this.getPathString();
        String newAbsolutePath = this.getAbsolutePathString();
        ((Document)this.document).getFileSection().getFile(this.getFileId()).replaceInFilePath(oldRelativePath, newRelativePath);
        FileUtil.renameTo((String)oldAbsolutePath, (String)newAbsolutePath);
    }

    @Override
    public void delete() throws IOException, FileOperationNotAllowedException, FileUtilExceptionListException {
        this.checkIfFileOperationNotAllowed(this.label, "Delete");
        String oldAbsolutePath = this.getAbsolutePathString();
        super.delete();
        this.getMyFileSectionFile().delete();
        FileUtil.delete((String)oldAbsolutePath);
    }

    @Override
    public void deleteAsDuplicate(NodeFile fileToKeep) throws FileOperationNotAllowedException, FileUtilExceptionListException {
        this.checkIfFileOperationNotAllowed(this.label, "Delete as duplicate");
        String oldAbsolutePath = this.getAbsolutePathString();
        super.deleteAsDuplicate(fileToKeep);
        this.getMyFileSectionFile().delete();
        FileUtil.delete((String)oldAbsolutePath);
    }

    public void deleteFileContent() throws FileOperationNotAllowedException, FileUtilExceptionListException, IOException, NodeFileDeletionNotAllowedException {
        this.checkIfFileOperationNotAllowed(this.label, "Delete file content");
        if (!this.getSubmitStatus().equals((java.lang.Object)NodeAbstract.SubmitStatus.Submitted)) {
            throw new NodeFileDeletionNotAllowedException(this.document, this.document.getName(), "Delete file content");
        }
        String oldAbsolutePath = this.getAbsolutePathString();
        this.createNewEvent("Deletion", "Removed the corresponding file content for this node", "Success", "");
        FileUtil.delete((String)oldAbsolutePath);
        this.initializeFileAccessRights();
    }

    public void migrateToFileKeepOriginal(String newFilePath) throws FileOperationNotAllowedException, FileUtilExceptionListException, FileNotFoundException, IOException, FileAlreadyExistsException {
        this.migrateToFileKeepOriginal(newFilePath, null);
    }

    public void migrateToFileKeepOriginal(String newFilePath, String migrationToolName) throws FileOperationNotAllowedException, FileUtilExceptionListException, FileNotFoundException, IOException, FileAlreadyExistsException {
        this.checkIfFileOperationNotAllowed(newFilePath, "MigrateToFileKeepOriginal");
        File newFile = new File(newFilePath);
        if (!newFile.exists()) {
            Exception.remember((String)("Migration file does not exist: " + newFilePath));
            return;
        }
        if (this.getMigrationDerivedNode() == null && this.getMigrationSourceNode() == null) {
            try {
                NodeFolder newFolder = null;
                if (this.isRoot().booleanValue()) {
                    newFolder = ((Document)this.document).getStructureMap().moveRootFileToNewRootFolder(this);
                } else {
                    newFolder = ((NodeFolder)this.parent).createNewFolder(UniqueID.getString());
                    newFolder.moveBeforeNode(this);
                    this.moveTo(newFolder);
                }
                if (newFolder.getLevel() != this.getLevel()) {
                    newFolder.setLevel(this.getLevel());
                }
                newFolder.rename(this.getLabel());
                newFolder.setUnitTitle(this.getUnitTitle());
                for (MetadataElementInstance metadataElementInstance : this.getDynamicMetadataElementInstances()) {
                    try {
                        newFolder.setDynamicMetadataValueForName_force(metadataElementInstance.getName(), metadataElementInstance.getValue());
                    }
                    catch (LevelMetadataElementIsReadOnly | MetadataElementAllowedValuesException | MetadataElementIsNotAllowedException | MetadataElementIsNotDefinedException | MetadataElementSetterPostActionException | MetadataElementValidatorException e) {
                        Exception.remember((Throwable)e);
                    }
                }
                NodeAbstract.SubmitStatus currentSubmitStatus = this.getSubmitStatus();
                if (!currentSubmitStatus.isEditingAllowed()) {
                    this.setSubmitStatus_force(NodeAbstract.SubmitStatus.SubmitUndefined);
                }
                if (this.getLevel() != newFolder.getLevel().getDefaultSubLevel()) {
                    this.setLevel(newFolder.getLevel().getDefaultSubLevel());
                }
                for (MetadataElementInstance mei : this.getDynamicMetadataElementInstances()) {
                    try {
                        if (mei.canBeDeleted()) {
                            this.deleteDynamicMetadataElementInstanceWithName(mei.getName(), mei.getIndex());
                            continue;
                        }
                        String defaultValue = null;
                        try {
                            defaultValue = mei.getLevelMetadataElement().getDefaultValueFromNode(this);
                        }
                        catch (EvalError e) {
                            Logger.warn((java.lang.Object)("Could not evaluate defaultExpresion: " + e.getMessage()));
                        }
                        if (defaultValue != null) {
                            this.setDynamicMetadataValueForName_force(mei.getName(), defaultValue);
                            continue;
                        }
                        this.setDynamicMetadataValueForName_force(mei.getName(), null);
                    }
                    catch (LevelMetadataElementIsReadOnly | MetadataElementAllowedValuesException | MetadataElementCantDeleteException | MetadataElementIsNotAllowedException | MetadataElementIsNotDefinedException | MetadataElementSetterPostActionException | MetadataElementValidatorException e) {
                        Exception.remember((Throwable)e);
                    }
                }
                newFolder.setSubmitStatusRecursivelyAllOrNone_force(currentSubmitStatus);
            }
            catch (FileAlreadyExistsException | FolderNameIsEmptyException | IOException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Exception.remember((Throwable)e);
                return;
            }
        }
        NodeAbstract newNode = ((NodeFolder)this.getParent()).insertFileOrFolder(newFilePath, true);
        newNode.setSubmitStatus_force(this.getSubmitStatus());
        String eventType = migrationToolName == null ? "File '" + this.label + "' migrated to file '" + newNode.getLabel() + "'" : "Application:" + migrationToolName + " - Source:" + this.label + " - Target:" + newNode.getLabel();
        Event event = this.getMyDigiprov().addNewEvent("Migration", eventType, "Success", "");
        Object newLastDigiprovObject = newNode.getMyDigiprov().getLastObject();
        newLastDigiprovObject.addRelationships(event);
        newLastDigiprovObject.setOriginalName(this.label);
        Object originalLastDigiprovObject = this.getMyLastDigiprovObject();
        originalLastDigiprovObject.addRelationships(event);
        originalLastDigiprovObject.setRelatedObject(newLastDigiprovObject, "source", "source for");
    }

    public void migrateToFile(String newFilePath) throws FileOperationNotAllowedException, FileUtilExceptionListException, FileNotFoundException, IOException, FileAlreadyExistsException {
        this.migrateToFile(newFilePath, null);
    }

    public void migrateToFile(String newFilePath, String migrationToolName) throws FileOperationNotAllowedException, FileUtilExceptionListException, FileNotFoundException, IOException, FileAlreadyExistsException {
        this.checkIfFileOperationNotAllowed(newFilePath, "MigrateToFile");
        File newFile = new File(newFilePath);
        if (!newFile.exists()) {
            Exception.remember((String)("Migration file does not exist: " + newFilePath));
            return;
        }
        if (Files.isRegularFile(Paths.get(newFilePath, new String[0]), new LinkOption[0])) {
            String oldLabel = this.label;
            this.replaceByFile(newFile);
            Object originalLastDigiprovObject = this.getMyLastDigiprovObject();
            String eventType = migrationToolName == null ? "File '" + oldLabel + "' migrated to file '" + this.label + "'" : "Application:" + migrationToolName + " - Source:" + oldLabel + " - Target:" + this.label;
            Event newMigrationEvent = this.getMyDigiprov().addNewEvent("Migration", eventType, "Success", "");
            Object newMigrationObject = this.getMyDigiprov().addNewObjectWithRelationship(this, newMigrationEvent);
            newMigrationObject.setOriginalName(oldLabel);
            originalLastDigiprovObject.addRelationships(newMigrationEvent);
            originalLastDigiprovObject.setRelatedObject(newMigrationObject, "source", "source for");
        } else {
            NodeFolder parentNode = (NodeFolder)this.getParent();
            NodeFolder newFolderNode = (NodeFolder)parentNode.insertFileOrFolder(newFilePath);
            newFolderNode.setUnitTitle(this.getUnitTitle());
            for (MetadataElementInstance mei : this.getDynamicMetadataElementInstances()) {
                try {
                    newFolderNode.setDynamicMetadataValueForName_force(mei.getName(), mei.getValue());
                }
                catch (LevelMetadataElementIsReadOnly | MetadataElementAllowedValuesException | MetadataElementIsNotAllowedException | MetadataElementIsNotDefinedException | MetadataElementSetterPostActionException | MetadataElementValidatorException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    Exception.remember((Throwable)e);
                }
            }
            Object originalLastDigiprovObject = this.getMyLastDigiprovObject();
            String eventType = migrationToolName == null ? "File '" + this.label + "' migrated to folder '" + newFolderNode.label + "'" : "Application:" + migrationToolName + " - Source:" + this.label + " - Target:" + newFolderNode.label;
            Event newMigrationEvent = this.getMyDigiprov().addNewEvent("Migration", eventType, "Success", "");
            Object newLastDigiprovObject = this.getMyDigiprov().addNewObjectWithRelationship(newFolderNode, newMigrationEvent);
            originalLastDigiprovObject.addRelationships(newMigrationEvent);
            originalLastDigiprovObject.setRelatedObject(newLastDigiprovObject, "source", "source for");
            String newADMID = newFolderNode.getAdmId();
            newFolderNode.setAdmId(this.admId);
            this.setAdmId(newADMID);
            this.delete();
        }
    }

    public NodeFile getMigrationDerivedNode() {
        return this.getTargetOfPremisRelationship("source for");
    }

    public NodeFile getMigrationSourceNode() {
        return this.getTargetOfPremisRelationship("derived from");
    }

    private NodeFile getTargetOfPremisRelationship(String relationshipSubType) {
        for (Object o : this.getMyDigiprov().getObjects()) {
            if (!o.getRelationshipSubType().equals(relationshipSubType)) continue;
            String targetPremisObjectID = o.getRelatedObjectIdValue();
            for (DigiprovWithPremis digiprovWithPremis : this.getDocument().getAMDSection().getDigiprovs()) {
                Object premisObject = digiprovWithPremis.getObject(targetPremisObjectID);
                if (premisObject == null) continue;
                return (NodeFile)this.getDocument().getStructureMap().searchId(digiprovWithPremis.getId());
            }
        }
        return null;
    }

    public void replaceByFile(String newFilePath) throws FileOperationNotAllowedException, FileUtilExceptionListException {
        this.checkIfFileOperationNotAllowed(newFilePath, "ReplaceByFile");
        File newFile = new File(newFilePath);
        if (!newFile.exists()) {
            Exception.remember((String)("Replacement file does not exist: " + newFilePath));
            return;
        }
        String oldLabel = this.label;
        this.replaceByFile(newFile);
        Event newMigrationEvent = this.getMyDigiprov().addNewEvent("Replacement", "Replaced file '" + oldLabel + "' by file '" + this.label + "'", "Success", "");
        Object newMigrationObject = this.getMyDigiprov().addNewObjectWithRelationship(this, newMigrationEvent);
        newMigrationObject.setOriginalName(oldLabel);
    }

    @Override
    public String toString() {
        return "[StructureMapFile:" + this.label + "[" + this.getLevel() + "](admId=" + this.admId + "/dmdIdOAI=" + this.dmdIdOAI_DC + "/dmdIdEAD=" + this.dmdIdEAD + "/fileId=" + this.fileId + ")(" + this.size + ")" + (this.fileExists ? "F" : "f") + (this.canRead ? "R" : "r") + (this.canWrite ? "W" : "w") + (this.canExecute ? "X" : "x") + "^" + (this.hasPredecessorNotReadableByCurrentUser() ? "r" : "R") + (this.hasPredecessorNotWritableByCurrentUser() ? "w" : "W") + "v--" + "(" + (java.lang.Object)((java.lang.Object)this.getSubmitStatus()) + ")]";
    }

    @Override
    public String treeString(Integer indent) {
        StringBuilder buf = new StringBuilder(50);
        buf.append("\n");
        for (int i = 0; i < indent; ++i) {
            buf.append("\t");
        }
        buf.append(this.toString());
        return buf.toString();
    }

    protected void initialize() {
        this.initializeFileAccessRights();
        this.allowsChildren = false;
        this.fileId = ((Element)this.element.selectSingleNode("./METS:div/METS:fptr")).attributeValue("FILEID");
        this.size = this.getFile().length();
    }

    private void replaceByFile(File newFile) throws FileUtilExceptionListException {
        Logger.getLogger().debug("Replacing file in node: '" + this + "' by file: '" + newFile + "'");
        String newFileName = newFile.getName();
        try {
            File oldFile = this.getFile();
            FileUtil.delete((File)oldFile);
            if (new File(oldFile.getParent() + "/" + newFileName).exists()) {
                int lastDot = newFileName.lastIndexOf(".");
                newFileName = newFileName.substring(0, lastDot) + UniqueID.getXML() + newFileName.substring(lastDot);
            }
            FileUtil.copyToOverwriting((String)newFile.getPath(), (String)(oldFile.getParent() + "/" + newFileName));
        }
        catch (IOException x) {
            Exception.remember((Throwable)x);
            return;
        }
        this.setLabel(newFileName);
        this.size = newFile.length();
        this.getMyFileSectionFile().replaceFile(this.label);
    }

    public ch.docuteam.darc.mets.filesec.File getMyFileSectionFile() {
        return ((Document)this.document).getFileSection().getFile(this.fileId);
    }

    private Object getMyLastDigiprovObject() {
        return this.getMyDigiprov().getLastObject();
    }

    @Override
    protected String compareString() {
        return "2" + this.getLabel();
    }

    void checkMimeType() {
        if (this.getMimeType().isEmpty()) {
            String[] exceptionArgs = new String[]{"No MimeType found for file", NO_MIME_TYPE_FOUND_EXCEPTION, this.getPathString()};
            Exception.rememberWithType((String[])exceptionArgs);
        }
    }

    void checkFormatKey() {
        if (this.getFormatKey().isEmpty()) {
            String[] exceptionArgs = new String[]{"No FormatID found for file", NO_FORMAT_ID_FOUND_EXCEPTION, this.getPathString()};
            Exception.rememberWithType((String[])exceptionArgs);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
        return result;
    }

    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeFile other = (NodeFile)obj;
        return !(this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId));
    }
}

