/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.structmap;

import ch.docuteam.darc.common.DocumentAbstract;
import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.tools.exception.Exception;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.id.UniqueID;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.dom4j.Element;

public class StructureMap
extends ch.docuteam.darc.common.NodeAbstract {
    protected NodeAbstract root;

    protected StructureMap() {
    }

    private StructureMap(Document document) {
        this.document = document;
        this.element = (Element)document.selectSingleNode("./METS:mets/METS:structMap");
        if (this.element.elements().size() != 1) {
            Exception.remember((String)("Bad number of root elements in the METS file's Structure Map. Expected: 1, found: " + this.element.elements().size()));
            this.document = null;
            this.element = null;
            return;
        }
        this.root = NodeAbstract.parse(this, (Element)this.element.elements().get(0));
    }

    public static StructureMap parse(Document document) {
        return new StructureMap(document);
    }

    public NodeAbstract getRoot() {
        return this.root;
    }

    public boolean containsId(String id) {
        return this.root.searchId(id) != null;
    }

    public void checkIfFileOperationNotAllowed(String fileName, String fileOp) throws FileOperationNotAllowedException {
        if (this.document.getDocumentType() == DocumentAbstract.Type.METS && !((Document)this.document).areFileOperationsAllowed()) {
            throw new FileOperationNotAllowedException(this.document, fileName, fileOp);
        }
    }

    public boolean hasNodesWithDynamicMetadataElementInstancesWhichAreMandatoryButNotSet() {
        for (NodeAbstract n : this.root.getWithDescendants()) {
            if (!n.hasDynamicMetadataElementInstancesWhichAreMandatoryButNotSet()) continue;
            return true;
        }
        return false;
    }

    public boolean checkFixity() {
        return this.root.checkFixity();
    }

    public boolean checkAgainstSubmissionAgreement() {
        return this.root.checkAgainstSubmissionAgreement();
    }

    public List<NodeFile> filesNotAllowedBySubmissionAgreement() {
        return this.root.filesNotAllowedBySubmissionAgreement();
    }

    public boolean checkAgainstSubmissionAgreement(SubmissionAgreement sa, String dssId) {
        return this.root.checkAgainstSubmissionAgreement(sa, dssId);
    }

    public List<NodeFile> filesNotAllowedBySubmissionAgreement(SubmissionAgreement sa, String dssId) {
        return this.root.filesNotAllowedBySubmissionAgreement(sa, dssId);
    }

    public NodeAbstract createRootNode(String sourceFilePath) throws IOException, FileAlreadyExistsException, FileOperationNotAllowedException, FileUtilExceptionListException {
        this.checkIfFileOperationNotAllowed(sourceFilePath, "CreateRootNode");
        if (this.root != null) {
            this.root.delete();
            this.root = null;
        }
        this.document.setIsAtLeastOneFileNotReadable(false);
        this.document.setIsAtLeastOneFileNotWritable(false);
        this.root = NodeAbstract.createRootNode(this, new File(sourceFilePath));
        return this.root;
    }

    public NodeFolder createNewRootFolder(String newRootFolderName) throws IOException, FileOperationNotAllowedException, FileUtilExceptionListException {
        this.checkIfFileOperationNotAllowed(newRootFolderName, "CreateNewRootFolder");
        if (this.root != null) {
            this.root.delete();
            this.root = null;
        }
        this.document.setIsAtLeastOneFileNotReadable(false);
        this.document.setIsAtLeastOneFileNotWritable(false);
        this.root = new NodeFolder(this, newRootFolderName);
        return (NodeFolder)this.root;
    }

    NodeFolder moveRootFileToNewRootFolder(NodeFile oldRootFile) throws FileOperationNotAllowedException, IOException, FileUtilExceptionListException, FileAlreadyExistsException {
        this.checkIfFileOperationNotAllowed(oldRootFile.getLabel(), "CreateNewRootFolder");
        this.document.setIsAtLeastOneFileNotReadable(false);
        this.document.setIsAtLeastOneFileNotWritable(false);
        this.root = new NodeFolder(this, UniqueID.getString());
        oldRootFile.moveTo((NodeFolder)this.root);
        oldRootFile.setType("file");
        return (NodeFolder)this.root;
    }

    public NodeAbstract searchId(String id) {
        return this.root.searchId(id);
    }

    public List<NodeAbstract> searchLabel(String label) {
        return this.root.searchLabel(label);
    }

    public NodeAbstract searchFileId(String fileId) {
        return this.root.searchFileId(fileId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("\n[StructureMap:");
        buf.append(this.root != null ? this.root.treeString(1) : "(empty)");
        buf.append("\n]");
        return buf.toString();
    }
}

