/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.sa.dss;

import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.darc.sa.common.NodeAbstract;
import ch.docuteam.darc.sa.dss.DataSubmissionSessionCategory;
import ch.docuteam.darc.sa.dss.DataSubmissionSessionRecordType;
import ch.docuteam.darc.sa.dss.FileFormats;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

public class DataSubmissionSession
extends NodeAbstract {
    private String dssID;
    private String title;
    private DataSubmissionSessionCategory category;
    private DataSubmissionSessionRecordType recordTypes;
    private FileFormats fileFormats;

    private DataSubmissionSession(SubmissionAgreement sa, Element element) {
        this.sa = sa;
        this.element = element;
        this.dssID = element.attributeValue("dssID");
        this.title = this.getElementText("SA:title", true);
        this.category = DataSubmissionSessionCategory.get(this.getElementText("SA:category", true));
        this.recordTypes = DataSubmissionSessionRecordType.get(this.getElementText("SA:recordTypes", true));
        this.fileFormats = FileFormats.parse(this.sa, this.element);
    }

    public static Map<String, DataSubmissionSession> parse(SubmissionAgreement sa, Element parent) {
        HashMap<String, DataSubmissionSession> dsss = new HashMap<String, DataSubmissionSession>();
        for (Object o : parent.selectNodes("./SA:dataSubmissionSession")) {
            DataSubmissionSession dss = new DataSubmissionSession(sa, (Element)o);
            dsss.put(dss.getDssID(), dss);
        }
        return dsss;
    }

    public String getDssID() {
        return this.dssID;
    }

    public String getTitle() {
        return this.title;
    }

    public DataSubmissionSessionCategory getCategory() {
        return this.category;
    }

    public DataSubmissionSessionRecordType getRecordTypes() {
        return this.recordTypes;
    }

    public FileFormats getFileFormats() {
        return this.fileFormats;
    }

    public boolean allowsFile(String filePath) throws FileNotFoundException {
        if (this.fileFormats == null) {
            return true;
        }
        return this.fileFormats.allowsFile(this.dssID, filePath);
    }

    public boolean allowsFileType(String filePath, String puid, String mimeType) {
        if (this.fileFormats == null) {
            return true;
        }
        return this.fileFormats.allowsFileType(this.dssID, filePath, puid, mimeType);
    }

    public String toString() {
        return "[DSS:" + (this.dssID + "/") + (this.title + "/") + ((Object)((Object)this.category) + "/") + ((Object)((Object)this.recordTypes) + "/") + (this.fileFormats + "]");
    }
}

