/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.util;

import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.mapping.util.MetsExportFacade;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.DateFormatter;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class ExporterUtil {
    public static final String PACKER_CONSTANTS_OPERATOR = "docuteam packer";
    public static final String EAD_DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String SEDA_MANIFEST_XML = "manifest.xml";
    public static final String CONTENT_PATH = "Content";
    public static final String DEFAULT_MIME_TYPE = "Unknown";
    public static final String DEFAULT_FORMAT_ID = "Unknown";
    public static final String MENTIONS_DE_PUBLICATION = "Mentions de publication";

    public static Path getValidSEDAMetadataPath(Path sedaSIPPath) {
        if (!sedaSIPPath.toFile().exists()) {
            sedaSIPPath.toFile().mkdirs();
        }
        return sedaSIPPath.resolve(SEDA_MANIFEST_XML);
    }

    public static XMLGregorianCalendar getNewXMLGregorianCalendar() {
        try {
            XMLGregorianCalendar newXMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            return newXMLGregorianCalendar;
        }
        catch (DatatypeConfigurationException e) {
            Logger.error((Object)"error at getNewXMLGregorianCalendar: ", (Throwable)e);
            return null;
        }
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(long millis) {
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(millis);
            XMLGregorianCalendar newXMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            return newXMLGregorianCalendar;
        }
        catch (DatatypeConfigurationException e) {
            Logger.error((Object)"error at getNewXMLGregorianCalendar: ", (Throwable)e);
            return null;
        }
    }

    public static XMLGregorianCalendar getXMLGregorianCalendarDATETIME(String dateTimeRepresentation) {
        try {
            GregorianCalendar gregorianCalendar = ExporterUtil.getGregorianCalendar(dateTimeRepresentation, "yyyy-MM-dd'T'HH:mm:ss");
            XMLGregorianCalendar newXMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            return newXMLGregorianCalendar;
        }
        catch (DatatypeConfigurationException e) {
            Logger.error((Object)("error at getNewXMLGregorianCalendar - dateTimeRepresentation: " + dateTimeRepresentation), (Throwable)e);
            return null;
        }
    }

    public static XMLGregorianCalendar getXMLGregorianCalendarDATE(String dateTimeRepresentation, String dateFormat) {
        try {
            GregorianCalendar gregorianCalendar = ExporterUtil.getGregorianCalendar(dateTimeRepresentation, dateFormat);
            if (gregorianCalendar != null) {
                XMLGregorianCalendar newXMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                return newXMLGregorianCalendar;
            }
        }
        catch (DatatypeConfigurationException e) {
            Logger.warn((Object)("error at getNewXMLGregorianCalendar - dateTimeRepresentation: " + dateTimeRepresentation), (Throwable)e);
        }
        return null;
    }

    static GregorianCalendar getGregorianCalendar(String dateTimeRepresentation, String dateFormat) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date parsedDate = DateFormatter.parse((String)dateTimeRepresentation, (String)dateFormat);
        if (parsedDate == null) {
            Logger.warn((Object)("getGregorianCalendar(): cannot parse " + dateTimeRepresentation + " with " + dateFormat));
            return null;
        }
        gregorianCalendar.setTime(parsedDate);
        return gregorianCalendar;
    }

    public static String getFormatId(ch.docuteam.darc.premis.Object premisObject) {
        String formatID = premisObject.getFormatRegistryKey();
        if (formatID == null || formatID.trim().isEmpty()) {
            formatID = "Unknown";
        }
        return formatID;
    }

    public static String getMimeType(ch.docuteam.darc.mets.filesec.File metsFile) {
        String mimeType = metsFile.getMimeType();
        if (mimeType == null || mimeType.trim().isEmpty()) {
            mimeType = "Unknown";
        }
        return mimeType;
    }

    public static String getSEDA_Uri(String metsFileName) {
        return "Content/" + metsFileName;
    }

    public static String addUniqueFileName(NodeAbstract metsStructMapNode, Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        if (metsStructMapNode instanceof NodeFolder) {
            return metsStructMapNode.getLabel();
        }
        String uniqueFileName = nodesToUniqueFileNamesMap.get(metsStructMapNode);
        if (uniqueFileName == null) {
            uniqueFileName = FileUtil.createUniqueFileName((String)metsStructMapNode.getLabel(), nodesToUniqueFileNamesMap.values());
            nodesToUniqueFileNamesMap.put(metsStructMapNode, uniqueFileName);
        }
        return uniqueFileName;
    }

    public static void copyFile(Document metsDocument, String fileId, Path sedaSIPPath, String relPath) {
        ch.docuteam.darc.mets.filesec.File metsFile = MetsExportFacade.getMetsFile(metsDocument, fileId);
        if (metsFile != null) {
            boolean contentDirCreated;
            File ioFile = sedaSIPPath.resolve(CONTENT_PATH).toFile();
            if (!ioFile.exists() && !(contentDirCreated = ioFile.mkdirs())) {
                Logger.error((Object)"cannot create SEDA Content dir");
            }
            Path sourcePath = Paths.get(metsFile.getAbsoluteFilePath(), new String[0]);
            Path targetPath = sedaSIPPath.resolve(relPath);
            try {
                Files.copy(sourcePath, targetPath, new CopyOption[0]);
                BasicFileAttributes attr = Files.readAttributes(sourcePath, BasicFileAttributes.class, new LinkOption[0]);
                Files.setAttribute(targetPath, "creationTime", attr.creationTime(), new LinkOption[0]);
                Files.setAttribute(targetPath, "lastAccessTime", attr.lastAccessTime(), new LinkOption[0]);
                Files.setAttribute(targetPath, "lastModifiedTime", attr.lastModifiedTime(), new LinkOption[0]);
            }
            catch (IOException e) {
                Logger.error((Object)"error at copyFile: ", (Throwable)e);
            }
        }
    }
}

