/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher;

import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.gui.GUIUtil;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CreateNewSIPDialog
extends JDialog {
    private LauncherView launcherView;
    protected JButton selectSourceFileOrFolderButton;
    protected JButton selectDestinationZIPOrFolderButton;
    protected JButton selectDestinationIsWorkspaceButton;
    protected JButton goButton;
    protected JRadioButton selectSIPEmptyRadioButton;
    protected JRadioButton selectSIPFromSourceFileOrFolderRadioButton;
    protected JTextField rootFolderNameTextField;
    protected JTextField sourceFileOrFolderTextField;
    protected JCheckBox deleteSourcesCheckBox;
    protected JTextField destinationFolderTextField;
    protected JTextField destinationNameTextField;
    protected JCheckBox beZIPCheckBox;
    protected JComboBox saComboBox;
    protected JLabel messageLabel;
    protected boolean goButtonWasClicked = false;

    protected CreateNewSIPDialog(LauncherView launcherView) {
        super(launcherView, I18N.translate((String)"TitleCreateNewSIP"), true);
        this.launcherView = launcherView;
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.setDefaultCloseOperation(2);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.selectSIPEmptyRadioButton = new JRadioButton();
        this.selectSIPEmptyRadioButton.setSelected(true);
        this.selectSIPEmptyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPDialog.this.selectSIPRootRadioButtonClicked();
            }
        });
        this.selectSIPFromSourceFileOrFolderRadioButton = new JRadioButton();
        this.selectSIPFromSourceFileOrFolderRadioButton.setName("SIP_SELECT_FROM_SOURCE_FILE_OR_FOLDER_RADIO_BUTTON");
        this.selectSIPFromSourceFileOrFolderRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPDialog.this.selectSIPRootRadioButtonClicked();
            }
        });
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(this.selectSIPEmptyRadioButton);
        radioButtonGroup.add(this.selectSIPFromSourceFileOrFolderRadioButton);
        this.rootFolderNameTextField = new JTextField("");
        this.rootFolderNameTextField.setName("SIP_CREATE_NEW_SIP_ROOT_NAME_TEXT_FIELD");
        this.rootFolderNameTextField.setToolTipText(I18N.translate((String)"ToolTipRootFolderName"));
        this.rootFolderNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPDialog.this.rootFolderNameTextFieldChanged();
            }
        });
        this.rootFolderNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CreateNewSIPDialog.this.rootFolderNameTextFieldChanged();
            }
        });
        this.selectSourceFileOrFolderButton = new JButton(PackerConstants.getImageIcon("OpenFolder.png"));
        this.selectSourceFileOrFolderButton.setName("SIP_SELECT_SOURCE_FILE_OR_FOLDER_BUTTON");
        this.selectSourceFileOrFolderButton.setToolTipText(I18N.translate((String)"ToolTipSelectSource"));
        this.selectSourceFileOrFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPDialog.this.selectSourceFolderButtonClicked();
            }
        });
        this.sourceFileOrFolderTextField = new JTextField(new File(launcherView.getDataDirectory()).getAbsolutePath());
        this.sourceFileOrFolderTextField.setToolTipText(I18N.translate((String)"ToolTipSourceFileOrFolder"));
        this.sourceFileOrFolderTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPDialog.this.sourceFolderTextFieldChanged();
            }
        });
        this.sourceFileOrFolderTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CreateNewSIPDialog.this.sourceFolderTextFieldChanged();
            }
        });
        this.selectDestinationZIPOrFolderButton = new JButton(PackerConstants.getImageIcon("OpenFolder.png"));
        this.selectDestinationZIPOrFolderButton.setToolTipText(I18N.translate((String)"ToolTipSelectDestinationFolder"));
        this.selectDestinationZIPOrFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPDialog.this.selectDestinationFolderButtonClicked();
            }
        });
        this.selectDestinationIsWorkspaceButton = new JButton(PackerConstants.getImageIcon("Workspace.png"));
        this.selectDestinationIsWorkspaceButton.setName("SIP_SELECT_DESTINATION_IS_WORKSPACE_BUTTON");
        this.selectDestinationIsWorkspaceButton.setToolTipText(I18N.translate((String)"ToolTipSelectDestinationIsWorkspaceFolder"));
        this.selectDestinationIsWorkspaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPDialog.this.selectDestinationIsWorkspaceButtonClicked();
            }
        });
        this.deleteSourcesCheckBox = new JCheckBox(I18N.translate((String)"LabelDeleteSources"), launcherView.isDeleteSourcesByDefault());
        this.deleteSourcesCheckBox.setToolTipText(I18N.translate((String)"ToolTipDeleteSources"));
        this.destinationFolderTextField = new JTextField(new File(launcherView.getLastUsedOpenOrSaveDirectory()).getAbsolutePath());
        this.destinationFolderTextField.setToolTipText(I18N.translate((String)"ToolTipDestinationFolder"));
        this.destinationFolderTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CreateNewSIPDialog.this.destinationFolderTextField.setText(CreateNewSIPDialog.this.destinationFolderTextField.getText().trim());
            }
        });
        this.destinationNameTextField = new JTextField(new File(launcherView.getDataDirectory()).getName());
        this.destinationNameTextField.setName("SIP_DESTINATION_NAME_TEXT_FIELD");
        this.destinationNameTextField.setToolTipText(I18N.translate((String)"ToolTipDestinationName"));
        this.destinationNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                CreateNewSIPDialog.this.enableOrDisableButtonsAndFields();
            }
        });
        this.destinationNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CreateNewSIPDialog.this.destinationNameTextField.setText(CreateNewSIPDialog.this.destinationNameTextField.getText().trim());
            }
        });
        this.beZIPCheckBox = new JCheckBox("ZIP", launcherView.isNewSIPZippedByDefault());
        this.beZIPCheckBox.setToolTipText(I18N.translate((String)"ToolTipBeZIP"));
        this.saComboBox = new JComboBox<Object>(this.readSAOverviewFile().toArray());
        this.saComboBox.setToolTipText(I18N.translate((String)"ToolTipSelectSA"));
        this.messageLabel = new JLabel();
        this.goButton = new JButton(PackerConstants.getImageIcon("Save.png"));
        this.goButton.setName("SIP_CREATE_OK_BUTTON");
        this.goButton.setToolTipText(I18N.translate((String)"ToolTipCreateNew"));
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPDialog.this.goButtonClicked();
            }
        });
        GridBagPanel gridBag = new GridBagPanel((Border)new EmptyBorder(10, 10, 10, 10), new Insets(0, 5, 0, 0));
        gridBag.add((Component)this.selectSIPEmptyRadioButton, 0, 0, 13);
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelNewSIPRootName")), 0, 1, 13);
        gridBag.add((Component)this.rootFolderNameTextField, 0, 4, 17, 2, 1.0, 0.0);
        gridBag.add((Component)this.selectSIPFromSourceFileOrFolderRadioButton, 1, 0, 13);
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelNewSIPSource")), 1, 1, 13);
        gridBag.add((Component)this.selectSourceFileOrFolderButton, 1, 3);
        gridBag.add((Component)this.sourceFileOrFolderTextField, 1, 1, 4, 6, 17, 2, 1.0, 0.0);
        gridBag.add((Component)this.deleteSourcesCheckBox, 2, 2, 4, 6, 17);
        gridBag.add((Component)new JLabel(" "), 3, 2);
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelNewSIPDestination")), 4, 1, 13);
        gridBag.add((Component)this.selectDestinationIsWorkspaceButton, 4, 2);
        gridBag.add((Component)this.selectDestinationZIPOrFolderButton, 4, 3);
        gridBag.add((Component)this.destinationFolderTextField, 4, 4, 17, 2, 2.0, 0.0);
        gridBag.add((Component)this.destinationNameTextField, 4, 5, 17, 2, 1.0, 0.0);
        gridBag.add((Component)this.beZIPCheckBox, 4, 6);
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelNewSIPSA")), 5, 1, 13);
        gridBag.add((Component)this.saComboBox, 5, 5, 4, 6, 17, 2, 1.0, 0.0);
        gridBag.add((Component)this.messageLabel, 6, 6, 0, 5, 13, 2, 1.0, 0.0);
        gridBag.add((Component)this.goButton, 6, 6, 13);
        this.add((Component)gridBag);
        this.setPreferredSize(new Dimension(800, 240));
        this.pack();
        this.setLocationRelativeTo(launcherView);
        this.rootFolderNameTextField.requestFocusInWindow();
        this.selectSIPRootRadioButtonClicked();
        this.setVisible(true);
    }

    protected void selectSIPRootRadioButtonClicked() {
        if (this.selectSIPEmptyRadioButton.isSelected()) {
            this.destinationNameTextField.setText(this.rootFolderNameTextField.getText());
        } else {
            this.destinationNameTextField.setText(new File(this.sourceFileOrFolderTextField.getText()).getName());
        }
        this.enableOrDisableButtonsAndFields();
    }

    protected void selectSourceFolderButtonClicked() {
        JFileChooser fileChooser = new JFileChooser(this.sourceFileOrFolderTextField.getText());
        fileChooser.setName("SIP_SELECT_SOURCE_FOLDER_FILE_CHOOSER");
        fileChooser.setFileSelectionMode(2);
        fileChooser.setDialogTitle(I18N.translate((String)"TitleSelectSourceFileOrFolder"));
        fileChooser.setMultiSelectionEnabled(false);
        int result = fileChooser.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        this.sourceFileOrFolderTextField.setText(fileChooser.getSelectedFile().getPath());
        this.sourceFolderTextFieldChanged();
    }

    protected void rootFolderNameTextFieldChanged() {
        this.rootFolderNameTextField.setText(this.rootFolderNameTextField.getText().trim());
        this.destinationNameTextField.setText(this.rootFolderNameTextField.getText());
        this.enableOrDisableButtonsAndFields();
    }

    protected void sourceFolderTextFieldChanged() {
        this.sourceFileOrFolderTextField.setText(this.sourceFileOrFolderTextField.getText().trim());
        this.destinationNameTextField.setText(new File(this.sourceFileOrFolderTextField.getText()).getName());
        this.enableOrDisableButtonsAndFields();
    }

    protected void selectDestinationFolderButtonClicked() {
        JFileChooser fileChooser = new JFileChooser(this.destinationFolderTextField.getText());
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(I18N.translate((String)"TitleSelectDestinationFolder"));
        fileChooser.setMultiSelectionEnabled(false);
        int result = fileChooser.showSaveDialog(this);
        if (result == 1) {
            return;
        }
        this.destinationFolderTextField.setText(fileChooser.getSelectedFile().getPath());
    }

    protected void selectDestinationIsWorkspaceButtonClicked() {
        this.destinationFolderTextField.setText(this.launcherView.getSipDirectory());
    }

    protected void goButtonClicked() {
        File destinationFile;
        String rootFolderName = this.rootFolderNameTextField.getText();
        String sourceFileOrFolder = this.sourceFileOrFolderTextField.getText();
        String destinationFolder = this.destinationFolderTextField.getText();
        String destinationName = this.destinationNameTextField.getText();
        if (destinationName.isEmpty()) {
            GUIUtil.shake((Window)this);
            this.messageLabel.setText(I18N.translate((String)"MessageDestinationNameIsEmpty"));
            return;
        }
        if (this.selectSIPFromSourceFileOrFolderRadioButton.isSelected()) {
            if (sourceFileOrFolder.isEmpty()) {
                GUIUtil.shake((Window)this);
                this.messageLabel.setText(I18N.translate((String)"MessageSourceFileOrFolderIsEmpty"));
                return;
            }
            if (destinationFolder.contains(sourceFileOrFolder)) {
                GUIUtil.shake((Window)this);
                this.messageLabel.setText(I18N.translate((String)"MessageDestinationIsWithinSource"));
                return;
            }
        } else if (rootFolderName.isEmpty()) {
            GUIUtil.shake((Window)this);
            this.messageLabel.setText(I18N.translate((String)"MessageRootFolderNameIsEmpty"));
            return;
        }
        if (this.beZIPCheckBox.isSelected()) {
            if (!destinationName.toLowerCase().endsWith(".zip")) {
                destinationName = destinationName + ".zip";
            }
        } else if (destinationName.toLowerCase().endsWith(".zip")) {
            destinationName = destinationName.substring(0, destinationName.length() - 4);
        }
        if ((destinationFile = new File(destinationFolder + "/" + destinationName)).exists()) {
            GUIUtil.shake((Window)this);
            this.messageLabel.setText(I18N.translate((String)"MessageSIPExistsAlready"));
            return;
        }
        this.launcherView.setDataDirectory(sourceFileOrFolder);
        this.launcherView.setLastUsedOpenOrSaveDirectory(destinationFolder);
        this.goButtonWasClicked = true;
        this.close();
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    protected List<SubmissionAgreement.Overview> readSAOverviewFile() {
        return SubmissionAgreement.getAllFinalOverviews();
    }

    protected void enableOrDisableButtonsAndFields() {
        if (this.selectSIPEmptyRadioButton.isSelected()) {
            this.rootFolderNameTextField.setEnabled(true);
            this.selectSourceFileOrFolderButton.setEnabled(false);
            this.sourceFileOrFolderTextField.setEnabled(false);
            this.goButton.setEnabled(!this.destinationNameTextField.getText().isEmpty() && !this.rootFolderNameTextField.getText().isEmpty());
        } else {
            this.rootFolderNameTextField.setEnabled(false);
            this.selectSourceFileOrFolderButton.setEnabled(true);
            this.sourceFileOrFolderTextField.setEnabled(true);
            this.goButton.setEnabled(!this.destinationNameTextField.getText().isEmpty() && !this.sourceFileOrFolderTextField.getText().isEmpty());
        }
    }
}

