/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher;

import ch.docuteam.darc.mets.Document;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.tools.translations.I18N;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class SIPFileChooser
extends JFileChooser {
    private static final ImageIcon SIPFolderIcon = PackerConstants.getImageIcon("Packet.png");

    public SIPFileChooser(String lastUsedOpenOrSaveDir) {
        super(lastUsedOpenOrSaveDir);
        this.setDialogType(0);
        this.setMultiSelectionEnabled(false);
        this.setDialogTitle(I18N.translate((String)"TitleOpenSIP"));
        this.setFileSelectionMode(2);
        this.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isHidden() || file.getName().startsWith(".")) {
                    return false;
                }
                if (file.isFile()) {
                    return file.getName().toLowerCase().endsWith(".zip");
                }
                return true;
            }

            @Override
            public String getDescription() {
                return "SIP Folder or ZIP-File";
            }
        });
        this.setFileView(new FileView(){

            @Override
            public Boolean isTraversable(File folder) {
                if (folder == null || !folder.exists() || !folder.canRead()) {
                    return false;
                }
                if (folder.isFile()) {
                    return false;
                }
                return !Document.isValidSIPFolder(folder);
            }

            @Override
            public Icon getIcon(File file) {
                if (file.isFile() ? file.getName().toLowerCase().endsWith(".zip") : Document.isValidSIPFolder(file)) {
                    return SIPFolderIcon;
                }
                return null;
            }
        });
    }
}

