/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class AssignLevelsByLabelDialog
extends JDialog {
    protected boolean goButtonWasClicked = false;
    protected final JComboBox comboBoxSeries;
    protected final JComboBox comboBoxDossier;
    protected final JComboBox comboBoxItem;
    protected final JButton goButton;

    protected AssignLevelsByLabelDialog(JFrame owner, final NodeAbstract node) {
        super(owner, I18N.translate((String)"TitleAssignLevelsByLabel"), true);
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.setDefaultCloseOperation(2);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignLevelsByLabelDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        Vector<LevelOfDescription> levels = new Vector<LevelOfDescription>(10);
        levels.add(null);
        levels.addAll(node.getDocument().getLevels().getAll());
        this.comboBoxSeries = new JComboBox(levels);
        this.comboBoxSeries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignLevelsByLabelDialog.this.enableOrDisableGoButton();
            }
        });
        levels = new Vector(10);
        levels.add(null);
        levels.addAll(node.getDocument().getLevels().getAll());
        this.comboBoxDossier = new JComboBox(levels);
        this.comboBoxDossier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignLevelsByLabelDialog.this.enableOrDisableGoButton();
            }
        });
        levels = new Vector(10);
        levels.add(null);
        levels.addAll(node.getDocument().getLevels().getAll());
        this.comboBoxItem = new JComboBox(levels);
        this.comboBoxItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignLevelsByLabelDialog.this.enableOrDisableGoButton();
            }
        });
        this.goButton = new JButton(PackerConstants.getImageIcon("Go.png"));
        this.goButton.setToolTipText(I18N.translate((String)"ToolTipAssignLevelsByLabel"));
        this.goButton.setEnabled(false);
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignLevelsByLabelDialog.this.goButtonClicked(node);
            }
        });
        GridBagPanel gridBagPanel = new GridBagPanel((Border)new EmptyBorder(10, 10, 10, 10), new Insets(2, 5, 0, 5));
        gridBagPanel.add((Component)new JLabel(I18N.translate((String)"LabelFunctionalLevel")), 0, 0, 10);
        gridBagPanel.add((Component)new JLabel(I18N.translate((String)"LabelAssignedLevel")), 0, 1, 10);
        gridBagPanel.add((Component)new JLabel(I18N.translate((String)"LabelSeries")), 2, 0, 10);
        gridBagPanel.add((Component)this.comboBoxSeries, 2, 1, 17);
        gridBagPanel.add((Component)new JLabel(I18N.translate((String)"LabelDossier")), 3, 0, 10);
        gridBagPanel.add((Component)this.comboBoxDossier, 3, 1, 17);
        gridBagPanel.add((Component)new JLabel(I18N.translate((String)"LabelItem")), 4, 0, 10);
        gridBagPanel.add((Component)this.comboBoxItem, 4, 1, 17);
        gridBagPanel.add((Component)this.goButton, 5, 1, 13);
        this.add((Component)gridBagPanel);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    protected void goButtonClicked(NodeAbstract topNode) {
        if (!this.areAllComboBoxesSet()) {
            return;
        }
        ExceptionCollector.clear();
        for (NodeAbstract node : topNode.getWithDescendants()) {
            try {
                if (node.isFile()) {
                    node.setLevel((LevelOfDescription)this.comboBoxItem.getSelectedItem());
                    continue;
                }
                if (((NodeFolder)node).doesLabelHaveNumericPrefix()) {
                    node.setLevel((LevelOfDescription)this.comboBoxSeries.getSelectedItem());
                    continue;
                }
                node.setLevel((LevelOfDescription)this.comboBoxDossier.getSelectedItem());
            }
            catch (Exception ex) {
                ch.docuteam.tools.exception.Exception.remember((Throwable)ex);
            }
        }
        this.goButtonWasClicked = true;
        this.close();
        if (!ExceptionCollector.isEmpty().booleanValue()) {
            ExceptionCollector.systemOut();
        }
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    protected void enableOrDisableGoButton() {
        this.goButton.setEnabled(this.areAllComboBoxesSet());
    }

    protected boolean areAllComboBoxesSet() {
        return this.comboBoxSeries.getSelectedItem() != null && this.comboBoxDossier.getSelectedItem() != null && this.comboBoxItem.getSelectedItem() != null;
    }
}

