/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class AssignLevelsByLayerDialog
extends JDialog {
    protected boolean goButtonWasClicked = false;
    protected final List<JComboBox> comboBoxes;
    protected final JButton goButton;

    protected AssignLevelsByLayerDialog(JFrame owner, final NodeAbstract node) {
        super(owner, I18N.translate((String)"TitleAssignLevelsByLayer"), true);
        int i;
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.setDefaultCloseOperation(2);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignLevelsByLayerDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.goButton = new JButton(PackerConstants.getImageIcon("Go.png"));
        this.goButton.setToolTipText(I18N.translate((String)"ToolTipAssignLevelsByLayer"));
        this.goButton.setEnabled(false);
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignLevelsByLayerDialog.this.goButtonClicked(node);
            }
        });
        int treeDepth = node.getTreeDepth() + 1;
        this.comboBoxes = new Vector<JComboBox>(treeDepth);
        GridBagPanel gridBagPanel = new GridBagPanel((Border)new EmptyBorder(10, 10, 10, 10), new Insets(2, 5, 0, 5));
        gridBagPanel.add((Component)new JLabel(I18N.translate((String)"LabelTreeLevel")), 0, 0, 10);
        gridBagPanel.add((Component)new JLabel(I18N.translate((String)"LabelAssignedLevel")), 0, 1, 10);
        for (i = 1; i <= treeDepth; ++i) {
            Vector<LevelOfDescription> levels = new Vector<LevelOfDescription>(10);
            levels.add(null);
            levels.addAll(node.getDocument().getLevels().getAll());
            JComboBox comboBox = new JComboBox(levels);
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssignLevelsByLayerDialog.this.enableOrDisableGoButton();
                }
            });
            this.comboBoxes.add(comboBox);
            gridBagPanel.add((Component)new JLabel("" + i), i + 1, 0, 10);
            gridBagPanel.add(comboBox, i + 1, 1, 17);
        }
        gridBagPanel.add((Component)this.goButton, i + 1, 1, 13);
        this.add((Component)gridBagPanel);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    protected void goButtonClicked(NodeAbstract topNode) {
        ExceptionCollector.clear();
        int topNodeDepth = topNode.getDepth();
        for (NodeAbstract node : topNode.getWithDescendants()) {
            int relativeNodeDepth = node.getDepth() - topNodeDepth;
            LevelOfDescription selectedLevel = (LevelOfDescription)this.comboBoxes.get(relativeNodeDepth).getSelectedItem();
            if (selectedLevel == null) continue;
            try {
                node.setLevel(selectedLevel);
            }
            catch (Exception ex) {
                ch.docuteam.tools.exception.Exception.remember((Throwable)ex);
            }
        }
        this.goButtonWasClicked = true;
        this.close();
        if (!ExceptionCollector.isEmpty().booleanValue()) {
            ExceptionCollector.systemOut();
        }
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    protected void enableOrDisableGoButton() {
        this.goButton.setEnabled(!this.areAllComboBoxesEmpty());
    }

    protected boolean areAllComboBoxesEmpty() {
        for (JComboBox comboBox : this.comboBoxes) {
            if (comboBox.getSelectedItem() == null) continue;
            return false;
        }
        return true;
    }
}

