/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.util.mets.DuplicateFinder;
import ch.docuteam.darc.util.mets.DuplicateNodeFile;
import ch.docuteam.packer.gui.sipView.DuplicatesTable;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.translations.I18N;
import com.google.common.collect.ListMultimap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DuplicatesTableDialog
extends JDialog {
    private ListMultimap<String, DuplicateNodeFile> duplicatesListMultimap;
    private List<DuplicatesTable> tableList = new ArrayList<DuplicatesTable>();
    private JButton okButton;
    private JButton cancelButton;
    private JButton clearSelectionButton;
    private SIPView sipView;

    public DuplicatesTableDialog(NodeAbstract nodeAbstract, SIPView sipView) {
        super(sipView, I18N.translate((String)"TitleRemoveDuplicatesDialog"), true);
        this.sipView = sipView;
        this.setDefaultCloseOperation(2);
        this.duplicatesListMultimap = DuplicateFinder.getDuplicates(nodeAbstract);
        this.okButton = new JButton(I18N.translate((String)"ButtonDuplicateSelectionRemove"));
        this.okButton.setToolTipText(I18N.translate((String)"ToolTipDuplicateSelectionRemove"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicatesTableDialog.this.removeDuplicateButtonClicked();
            }
        });
        this.cancelButton = new JButton(I18N.translate((String)"ButtonCancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicatesTableDialog.this.cancelButtonClicked();
            }
        });
        this.clearSelectionButton = new JButton(I18N.translate((String)"ButtonDuplicateSelectionClear"));
        this.clearSelectionButton.setToolTipText(I18N.translate((String)"ToolTipDuplicateSelectionClear"));
        this.clearSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicatesTableDialog.this.clearButtonClicked();
            }
        });
        GridBagPanel gridBag = new GridBagPanel((Border)new EmptyBorder(1, 1, 1, 1), new Insets(5, 5, 5, 5));
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelSelectDuplicateForRemoval")), 1, 1, 1, 4, 17);
        GridBagPanel innerGridBag = new GridBagPanel((Border)new BevelBorder(1), new Insets(1, 1, 1, 1));
        Iterator keyIterator = this.duplicatesListMultimap.keySet().iterator();
        int rowIndex = 1;
        while (keyIterator.hasNext()) {
            String nextKey = (String)keyIterator.next();
            List valueList = this.duplicatesListMultimap.get((Object)nextKey);
            DuplicatesTable currentTable = new DuplicatesTable(valueList, false);
            this.tableList.add(currentTable);
            innerGridBag.add((Component)currentTable, rowIndex, rowIndex, 1, 1, 10, 0, 1.0, 0.1);
            ++rowIndex;
        }
        gridBag.add((Component)new JScrollPane((Component)innerGridBag), 2, 2, 1, 4, 10, 1, 1.0, 1.0);
        Box buttonBox = new Box(0);
        buttonBox.add(this.clearSelectionButton);
        buttonBox.add(Box.createHorizontalStrut(600));
        buttonBox.add(this.okButton);
        buttonBox.add(this.cancelButton);
        gridBag.add((Component)buttonBox, 3, 3, 1, 4, 17);
        this.add((Component)gridBag);
        this.setPreferredSize(new Dimension(900, 600));
        this.pack();
        this.setLocationRelativeTo(sipView);
        this.setVisible(true);
    }

    private void removeDuplicateButtonClicked() {
        boolean anythingDeleted = false;
        for (DuplicatesTable table : this.tableList) {
            List<DuplicateNodeFile> duplicateList = table.getSelected();
            anythingDeleted |= DuplicateFinder.deleteAsDuplicates(this.duplicatesListMultimap, duplicateList);
        }
        this.dispose();
        if (anythingDeleted) {
            this.sipView.updateTree();
        }
    }

    private void cancelButtonClicked() {
        this.dispose();
    }

    private void clearButtonClicked() {
        for (DuplicatesTable table : this.tableList) {
            table.clearSelection();
        }
    }
}

