/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;

public class TreeNodeListTransferable
implements Transferable {
    protected static final DataFlavor DocuteamPackerTreeNodeListDataFlavor = new DataFlavor(Object.class, "DocuteamPackerTreeNodeListDataFlavor");
    protected static final DataFlavor[] SupportedDataFlavors = new DataFlavor[]{DocuteamPackerTreeNodeListDataFlavor};
    private String sipPath;
    private List<NodeAbstract> draggedNodes = new Vector<NodeAbstract>();
    private TreePath parentPath;

    protected TreeNodeListTransferable(JXTreeTable treeTable) {
        for (int i : treeTable.getSelectedRows()) {
            this.draggedNodes.add((NodeAbstract)treeTable.getPathForRow(i).getLastPathComponent());
        }
        this.sipPath = this.draggedNodes.get(0).getDocument().getSIPFolder();
        this.parentPath = treeTable.getPathForRow(treeTable.getSelectedRows()[0]).getParentPath();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return SupportedDataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DocuteamPackerTreeNodeListDataFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (DocuteamPackerTreeNodeListDataFlavor.equals(flavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public TreePath getParentPath() {
        return this.parentPath;
    }

    public List<NodeAbstract> getDraggedNodes() {
        return this.draggedNodes;
    }

    public String getSipPath() {
        return this.sipPath;
    }
}

