/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView.actions;

import ch.docuteam.darc.exceptions.FileOrFolderIsInUseException;
import ch.docuteam.darc.exceptions.OriginalSIPIsMissingException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.gui.SmallPeskyMessageWindow;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

public class SaveUtility {
    private Document document;
    private SIPView sipView;

    protected void saveAsButtonClicked() {
        FileDialog fileDialog = new FileDialog((Frame)this.sipView, I18N.translate((String)"TitleSaveSIPAs"), 1);
        fileDialog.setDirectory(new File(this.sipView.getLauncherView().getLastUsedOpenOrSaveDirectory()).getAbsolutePath());
        fileDialog.setFile(this.document.getSIPName());
        fileDialog.setLocationRelativeTo(this.sipView);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        this.saveCopyAs(fileDialog.getDirectory() + fileDialog.getFile());
    }

    protected void saveCopyAs(String filePath) {
        this.saveCopyAs(filePath, false);
    }

    protected void saveCopyAs(final String filePath, final boolean doUnlockAndCleanupAfterwards) {
        if (this.document == null) {
            return;
        }
        new SwingWorker<Integer, Object>(){

            @Override
            public Integer doInBackground() {
                SmallPeskyMessageWindow waitWindow = SmallPeskyMessageWindow.openBlocking((Window)SaveUtility.this.sipView, (String)I18N.translate((String)"MessageTempSavingSIP"));
                try {
                    SaveUtility.this.sipView.setCursor(Cursor.getPredefinedCursor(3));
                    SaveUtility.this.sipView.getLauncherView().savingDocumentInProgress(SaveUtility.this.sipView);
                    if (filePath == null || filePath.isEmpty()) {
                        if (!SaveUtility.this.document.canWrite()) {
                            JOptionPane.showMessageDialog(SaveUtility.this.sipView, I18N.translate((String)"MessageIsReadOnlyCantSave"), I18N.translate((String)"TitleCantSaveSIP"), 0);
                            Integer n = 0;
                            return n;
                        }
                        Logger.getLogger().debug("Saving document");
                        if (SIPView.saveWithBackups) {
                            SaveUtility.this.document.saveWithBackup();
                        } else {
                            SaveUtility.this.document.saveWithoutBackup();
                        }
                    } else {
                        Logger.getLogger().debug("Saving document as: " + filePath);
                        SaveUtility.this.document.saveTo(filePath);
                    }
                    SaveUtility.this.sipView.getLauncherView().getSipTable().rereadSIPTable();
                    if (doUnlockAndCleanupAfterwards) {
                        try {
                            SaveUtility.this.document.unlockIfNecessary();
                            SaveUtility.this.document.cleanupWorkingCopy();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(SaveUtility.this.sipView, e.toString(), "Unable to cleanup working folder due to errors", 0);
                        }
                    }
                    SaveUtility.this.sipView.setFooterText(I18N.translate((String)"MessageFooterSaved") + SaveUtility.this.document.getFilePath());
                    SaveUtility.this.sipView.setTitle(SaveUtility.this.document.getOriginalSIPFolder());
                }
                catch (FileOrFolderIsInUseException e) {
                    waitWindow.close();
                    JOptionPane.showMessageDialog(SaveUtility.this.sipView, I18N.translate((String)"MessageFileOrFolderIsInUseException", (Object[])new Object[]{e.getOriginalSIPName(), e.getSecurityCopySIPName(), FileUtil.asFileName((String)e.getOriginalSIPName()), FileUtil.asFileName((String)e.getSecurityCopySIPName())}), I18N.translate((String)"TitleCantSaveSIP"), 0);
                }
                catch (OriginalSIPIsMissingException e) {
                    waitWindow.close();
                    JOptionPane.showMessageDialog(SaveUtility.this.sipView, I18N.translate((String)"MessageOriginalSIPIsMissingException", (Object[])new Object[]{e.getOriginalSIPFolderPath()}), I18N.translate((String)"TitleCantCopySIP"), 2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    waitWindow.close();
                    JOptionPane.showMessageDialog(SaveUtility.this.sipView, e.toString(), I18N.translate((String)"TitleCantSaveSIP"), 0);
                    SaveUtility.this.sipView.setFooterText(I18N.translate((String)"MessageFooterCantSave") + SaveUtility.this.document.getFilePath());
                }
                finally {
                    SaveUtility.this.sipView.getLauncherView().savingDocumentFinished(SaveUtility.this.sipView);
                    waitWindow.close();
                    SaveUtility.this.sipView.setCursor(Cursor.getPredefinedCursor(0));
                    SaveUtility.this.sipView.enableOrDisableActions();
                    SaveUtility.this.sipView.toFront();
                    SaveUtility.this.sipView.requestFocus();
                }
                return 0;
            }
        }.execute();
    }
}

