/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4;

import uk.gov.nationalarchives.droid.core.signature.ByteReader;

@Deprecated
public class ByteSeqSpecifier {
    private byte[] minSeq;
    private byte[] maxSeq;
    private boolean negate;

    public int getNumBytes() {
        return this.minSeq.length;
    }

    public ByteSeqSpecifier(StringBuffer asciiRep) throws Exception {
        String maxRange;
        String minRange;
        String specifier;
        if (asciiRep.charAt(0) != '[') {
            specifier = asciiRep.substring(0, 2);
            asciiRep.delete(0, 2);
        } else {
            specifier = asciiRep.substring(1, asciiRep.indexOf("]"));
            asciiRep.delete(0, specifier.length() + 2);
        }
        this.negate = false;
        while (specifier.charAt(0) == '!' || specifier.charAt(0) == '~') {
            if (specifier.charAt(0) == '!') {
                this.negate = !this.negate;
            }
            specifier = specifier.substring(1);
        }
        int colonPos = specifier.indexOf(58);
        if (colonPos >= 0) {
            minRange = specifier.substring(0, colonPos);
            maxRange = specifier.substring(colonPos + 1);
        } else {
            minRange = specifier;
            maxRange = specifier;
        }
        if (minRange.length() != maxRange.length()) {
            throw new Exception("Invalid internal signature supplied");
        }
        int seqLength = minRange.length() / 2;
        this.minSeq = new byte[seqLength];
        this.maxSeq = new byte[seqLength];
        for (int i = 0; i < seqLength; ++i) {
            int byteVal = Integer.parseInt(minRange.substring(2 * i, 2 * (i + 1)), 16);
            this.minSeq[i] = (byte)(byteVal + -128);
            byteVal = Integer.parseInt(maxRange.substring(2 * i, 2 * (i + 1)), 16);
            this.maxSeq[i] = (byte)(byteVal + -128);
        }
    }

    public boolean matchesByteSequence(ByteReader file, long startPos, int direction, boolean bigEndian) {
        try {
            int fileByte;
            int arrayPos;
            if (!bigEndian && direction == 1) {
                direction = -1;
                startPos += (long)(this.getNumBytes() - 1);
            } else if (bigEndian && direction == -1) {
                direction = 1;
                startPos = startPos - (long)this.getNumBytes() + 1L;
            }
            int fileOffset = 0;
            for (arrayPos = direction == 1 ? 0 : this.getNumBytes() - 1; 0 <= arrayPos && arrayPos < this.getNumBytes(); arrayPos += direction) {
                fileByte = file.getByte(startPos + (long)fileOffset);
                if (fileByte < 0) {
                    fileByte += 256;
                }
                if ((fileByte -= 128) < this.minSeq[arrayPos]) {
                    return this.negate;
                }
                if (fileByte > this.minSeq[arrayPos]) break;
                fileOffset += direction;
            }
            fileOffset = 0;
            for (arrayPos = direction == 1 ? 0 : this.getNumBytes() - 1; arrayPos >= 0 && arrayPos < this.getNumBytes(); arrayPos += direction) {
                fileByte = file.getByte(startPos + (long)fileOffset);
                if (fileByte < 0) {
                    fileByte += 256;
                }
                if ((fileByte -= 128) > this.maxSeq[arrayPos]) {
                    return this.negate;
                }
                if (fileByte < this.maxSeq[arrayPos]) break;
                fileOffset += direction;
            }
            return !this.negate;
        }
        catch (Exception e) {
            return false;
        }
    }
}

