/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.iff.Superchunk;
import edu.harvard.hul.ois.jhove.module.wave.LabelChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabeledTextChunk;
import edu.harvard.hul.ois.jhove.module.wave.NoteChunk;
import java.io.DataInputStream;
import java.io.IOException;

public class AssocDataListChunk
extends Superchunk {
    public AssocDataListChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream, RepInfo repInfo) {
        super(moduleBase, chunkHeader, dataInputStream, repInfo);
    }

    public boolean readChunk(RepInfo repInfo) throws IOException {
        ChunkHeader chunkHeader;
        WaveModule waveModule = (WaveModule)this._module;
        String string = waveModule.read4Chars(this._dstream);
        if (!"adtl".equals(string)) {
            repInfo.setMessage((Message)new ErrorMessage("Unknown list type in Associated Data List Chunk", "Type = " + string, this._module.getNByte()));
            repInfo.setWellFormed(false);
            return false;
        }
        while ((chunkHeader = this.getNextChunkHeader()) != null) {
            Chunk chunk = null;
            String string2 = chunkHeader.getID();
            int n = (int)chunkHeader.getSize();
            if (string2.equals("labl")) {
                chunk = new LabelChunk(this._module, chunkHeader, this._dstream);
            } else if (string2.equals("note")) {
                chunk = new NoteChunk(this._module, chunkHeader, this._dstream);
            } else if (string2.equals("ltxt")) {
                chunk = new LabeledTextChunk(this._module, chunkHeader, this._dstream);
            }
            if (chunk == null) {
                this._module.skipBytes(this._dstream, n, this._module);
                repInfo.setMessage((Message)new InfoMessage("Chunk type '" + string2 + "' in Associated Data Chunk ignored"));
                continue;
            }
            if (((Chunk)chunk).readChunk(repInfo)) continue;
            return false;
        }
        return true;
    }
}

