/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.exception;

import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.string.DateFormatter;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang.ArrayUtils;

public class Exception {
    private static final String DateFormatString = "HH:mm:ss.SSS";
    private Date timeStamp = new Date();
    private String className;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private String message;
    private Throwable exception;
    private String exceptionType;
    private String[] exceptionCause;

    private Exception(String message) {
        this.message = message;
        StackTraceElement caller = Thread.currentThread().getStackTrace()[3];
        this.className = caller.getClassName();
        this.methodName = caller.getMethodName();
        this.lineNumber = caller.getLineNumber();
        this.fileName = caller.getFileName();
    }

    private Exception(Throwable x) {
        this.exception = x;
        this.message = x.getMessage();
        StackTraceElement caller = x.getStackTrace()[0];
        this.className = caller.getClassName();
        this.methodName = caller.getMethodName();
        this.lineNumber = caller.getLineNumber();
        this.fileName = caller.getFileName();
    }

    public static void remember(String message) {
        ExceptionCollector.add(new Exception(message));
    }

    public static void rememberWithType(String ... args) {
        Exception exception = null;
        if (args.length > 0) {
            exception = new Exception(args[0]);
        }
        if (args.length > 1) {
            exception.setExceptionType(args[1]);
        }
        if (args.length > 2) {
            String[] cause = Arrays.copyOfRange(args, 2, args.length);
            exception.setExceptionCause(cause);
        }
        if (exception != null) {
            ExceptionCollector.add(exception);
        }
    }

    public static void remember(Throwable x) {
        ExceptionCollector.add(new Exception(x));
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getDescription() {
        return this.exception == null ? this.message : this.exception.toString();
    }

    public String toString() {
        return "Exception: " + this.className + "." + this.methodName + "()[" + this.lineNumber + "]: " + this.getDescription();
    }

    public String toStringLong() {
        return "[Exception: " + DateFormatter.getDateTimeString(this.timeStamp, DateFormatString) + ":" + this.className + "." + this.methodName + "(): " + this.getDescription() + "]";
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String[] getExceptionCause() {
        if (this.exceptionCause == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return this.exceptionCause;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    public void setExceptionCause(String ... exceptionCause) {
        this.exceptionCause = exceptionCause;
    }
}

