/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.iptc.IptcDirectory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class MetadataFromJPGFile {
    public static Directory getEXIF(String jpgPicFileName) throws JpegProcessingException, IOException {
        return MetadataFromJPGFile.getEXIF(new File(jpgPicFileName));
    }

    public static Directory getEXIF(File jpgPic) throws JpegProcessingException, IOException {
        MetadataFromJPGFile.checkFile(jpgPic);
        return JpegMetadataReader.readMetadata((File)jpgPic).getDirectory(ExifIFD0Directory.class);
    }

    public static Directory getIPTC(String jpgPicFileName) throws JpegProcessingException, IOException {
        return MetadataFromJPGFile.getIPTC(new File(jpgPicFileName));
    }

    public static Directory getIPTC(File jpgPic) throws JpegProcessingException, IOException {
        MetadataFromJPGFile.checkFile(jpgPic);
        return JpegMetadataReader.readMetadata((File)jpgPic).getDirectory(IptcDirectory.class);
    }

    private static void checkFile(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("File '" + file + "' is supposed to be a file, but is a directory.");
        }
    }
}

