/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import javax.swing.ImageIcon;

public class ResourceUtil {
    static final String CONFIG_REL_PATH = "/config";
    private static ResourceUtil resourceUtil;

    private ResourceUtil() {
    }

    public static File getResource(String relPath) {
        Logger.debug("getResource - relPath: " + relPath);
        URL resource = ResourceUtil.getResourceURL(relPath);
        if (resource != null) {
            String filePath = null;
            try {
                filePath = URLDecoder.decode(resource.getFile(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Logger.error("cannot getResource for relPath: " + relPath, e);
            }
            return new File(filePath);
        }
        Logger.debug("getResource - not found!");
        return null;
    }

    public static URL getResourceURL(String relPath) {
        URL url;
        Logger.debug("getResourceURL - relPath: " + relPath);
        if (relPath == null) {
            return null;
        }
        relPath = ResourceUtil.getValidRelPath(relPath);
        if (resourceUtil == null) {
            resourceUtil = new ResourceUtil();
        }
        if ((url = resourceUtil.getClass().getResource(relPath)) == null) {
            Logger.debug("getResourceURL - not found!");
        }
        return url;
    }

    private static String getValidRelPath(String relPath) {
        if (!relPath.startsWith(File.separator) && !relPath.startsWith("/")) {
            relPath = "/" + relPath;
        }
        return relPath;
    }

    public static String getResourceCanonicalPath(String relPath) {
        Logger.debug("getResourceCanonicalPath - relPath: " + relPath);
        File file = ResourceUtil.getResource(relPath);
        try {
            if (file != null) {
                return file.getCanonicalPath();
            }
        }
        catch (IOException e) {
            Logger.error("cannot getResourceCanonicalPath for relPath: " + relPath, e);
        }
        return null;
    }

    public static File getConfigFolder() {
        Logger.debug("getConfigFolder");
        if (resourceUtil == null) {
            resourceUtil = new ResourceUtil();
        }
        return ResourceUtil.getResource(CONFIG_REL_PATH);
    }

    public static InputStream getResourceAsStream(String relPath) {
        Logger.debug("getResourceAsStream - relPath: " + relPath);
        if (resourceUtil == null) {
            resourceUtil = new ResourceUtil();
        }
        relPath = ResourceUtil.getValidRelPath(relPath);
        InputStream inputStream = resourceUtil.getClass().getResourceAsStream(relPath);
        if (inputStream == null) {
            Logger.debug("getResourceAsStream - not found!");
        }
        return inputStream;
    }

    public static InputStream getFileOrResourceInputStream(String fileName) throws FileNotFoundException {
        InputStream is = null;
        File configFile = new File(fileName);
        is = configFile.exists() ? new FileInputStream(configFile) : ResourceUtil.getResourceAsStream(fileName);
        return is;
    }

    public static void copyResourceFile(String source, String target) throws IOException, FileUtilExceptionListException {
        if (new File(source).exists()) {
            FileUtil.copyToOverwriting(source, target);
            return;
        }
        try (InputStream inputStream = ResourceUtil.getResourceAsStream(source);){
            Files.copy(inputStream, Paths.get(target, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static ImageIcon getImageIcon(String filename) {
        if (new File(filename).exists()) {
            return new ImageIcon(filename);
        }
        URL url = ResourceUtil.getResourceURL("/images/" + filename);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    public static Image getImage(String filename) {
        if (new File(filename).exists()) {
            return Toolkit.getDefaultToolkit().getImage(filename);
        }
        URL url = ResourceUtil.getResourceURL("/images/" + filename);
        if (url != null) {
            return Toolkit.getDefaultToolkit().getImage(url);
        }
        return null;
    }

    public static Properties getProperties(String configFileName) {
        Properties properties = new Properties();
        try (InputStream in = ResourceUtil.getResourceAsStream(configFileName);){
            if (in != null) {
                properties.load(in);
            }
        }
        catch (IOException e) {
            Logger.error("cannot read property file: " + configFileName, e);
        }
        return properties;
    }
}

