/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file.ssh;

import ch.docuteam.tools.out.Logger;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class SSHSession {
    private String user;
    private String host;
    private int port;
    private String privateKeyFile;
    private String knownHostsFile;
    private Session session;
    private JSch jsch;

    public SSHSession(String user, String host, int port, String privateKeyFile, String knownHostsFile) {
        this.user = user;
        this.host = host;
        this.port = port;
        this.privateKeyFile = privateKeyFile;
        this.knownHostsFile = knownHostsFile;
    }

    public Session connect() throws JSchException, FileNotFoundException {
        if (this.session == null) {
            Logger.debug("Creating new SSH Session");
            this.session = this.getJsch().getSession(this.user, this.host, this.port);
        }
        if (!this.session.isConnected()) {
            Logger.debug("Connecting SSH Session");
            this.session.connect();
        }
        Logger.debug("Host connected");
        return this.session;
    }

    public void disconnect() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
            Logger.debug("Host Session disconnected");
        }
    }

    private JSch getJsch() throws JSchException, FileNotFoundException {
        if (this.jsch == null) {
            this.jsch = new JSch();
            try (FileInputStream hostsStream = new FileInputStream(this.knownHostsFile);){
                this.jsch.setKnownHosts((InputStream)hostsStream);
                this.jsch.addIdentity(this.privateKeyFile);
            }
            catch (FileNotFoundException e) {
                Logger.error("Could not find known hosts file!", e);
                throw e;
            }
            catch (IOException e) {
                Logger.warn("Could not properly close the known hosts file at '" + this.knownHostsFile + "'");
            }
            catch (JSchException e) {
                Logger.error("Could not initialize a secure channel!", e);
                throw e;
            }
        }
        return this.jsch;
    }
}

