/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class GridBagPanel
extends JPanel
implements Observer {
    private static final Border DefaultBorder = new EmptyBorder(10, 10, 10, 10);
    private static final Insets DefaultInsets = new Insets(0, 0, 0, 0);
    private Insets insets = DefaultInsets;

    public GridBagPanel() {
        super(new GridBagLayout());
        this.setBorder(DefaultBorder);
    }

    public GridBagPanel(Insets insets) {
        this();
        this.insets = insets;
    }

    public GridBagPanel(Border border) {
        this();
        this.setBorder(border);
    }

    public GridBagPanel(Border border, Insets insets) {
        this();
        this.insets = insets;
        this.setBorder(border);
    }

    @Override
    public Component add(Component component) {
        return this.add(component, -1);
    }

    @Override
    public Component add(Component component, int row) {
        return this.add(component, row, -1);
    }

    public Component add(Component component, int row, int column) {
        return this.add(component, row, row, column, column);
    }

    public Component add(Component component, int row, int column, int anchor) {
        return this.add(component, row, row, column, column, anchor);
    }

    public Component add(Component component, int fromRow, int toRow, int fromColumn, int toColumn) {
        return this.add(component, fromRow, toRow, fromColumn, toColumn, 10);
    }

    public Component add(Component component, int fromRow, int toRow, int fromColumn, int toColumn, int anchor) {
        return this.add(component, fromRow, toRow, fromColumn, toColumn, anchor, 0, 0.0, 0.0);
    }

    public Component add(Component component, int row, int column, int anchor, int fill, double weightx, double weighty) {
        return this.add(component, row, row, column, column, anchor, fill, weightx, weighty, this.insets);
    }

    public Component add(Component component, int fromRow, int toRow, int fromColumn, int toColumn, int anchor, int fill, double weightx, double weighty) {
        return this.add(component, fromRow, toRow, fromColumn, toColumn, anchor, fill, weightx, weighty, this.insets);
    }

    public Component add(Component component, int fromRow, int toRow, int fromColumn, int toColumn, int anchor, int fill, double weightx, double weighty, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = fromRow;
        gbc.gridx = fromColumn;
        gbc.gridheight = toRow - fromRow + 1;
        gbc.gridwidth = toColumn - fromColumn + 1;
        gbc.anchor = anchor;
        gbc.fill = fill;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        ((GridBagLayout)this.getLayout()).setConstraints(component, gbc);
        super.add(component);
        return component;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (mgr.getClass() != GridBagLayout.class) {
            throw new RuntimeException("It's not possible to set a new layout in DLPanel other that a GridBagLayout");
        }
        super.setLayout(mgr);
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public void update(Observable observable, Object parameter) {
    }
}

