/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class SmallPeskyProgressBarWindow
extends JDialog
implements Observer {
    private JProgressBar progressBar;
    private boolean isBlocking = false;

    public static void main(String[] args) {
        final JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JButton b = new JButton();
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SwingWorker<Integer, Object>(){

                    @Override
                    public Integer doInBackground() {
                        SmallPeskyProgressBarWindow w = SmallPeskyProgressBarWindow.openBlocking(f, 3);
                        try {
                            Thread.sleep(1000L);
                            w.nextValue();
                            Thread.sleep(1000L);
                            w.nextValue();
                            Thread.sleep(1000L);
                            w.nextValue();
                            Thread.sleep(1000L);
                            w.nextValue();
                            Thread.sleep(1000L);
                            w.nextValue();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        w.close();
                        return 0;
                    }
                }.execute();
            }
        });
        f.add(b);
        f.setSize(400, 200);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private SmallPeskyProgressBarWindow(Window parent, int maximum, boolean isBlocking) {
        super(parent);
        this.isBlocking = isBlocking;
        if (this.isBlocking && parent != null) {
            parent.setEnabled(false);
        }
        this.setUndecorated(true);
        this.progressBar = new JProgressBar(0, maximum);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        p.add((Component)this.progressBar, "Center");
        this.add(p);
        this.setSize(300, 100);
        this.setLocationRelativeTo(parent);
    }

    public static SmallPeskyProgressBarWindow open(Window parent, int max) {
        SmallPeskyProgressBarWindow w = new SmallPeskyProgressBarWindow(parent, max, false);
        w.setCursor(Cursor.getPredefinedCursor(3));
        w.setVisible(true);
        return w;
    }

    public static SmallPeskyProgressBarWindow openBlocking(Window parent, int max) {
        SmallPeskyProgressBarWindow w = new SmallPeskyProgressBarWindow(parent, max, true);
        w.setCursor(Cursor.getPredefinedCursor(3));
        w.setVisible(true);
        return w;
    }

    public void setValue(int value) {
        this.progressBar.setValue(value);
    }

    public void nextValue() {
        this.progressBar.setValue(this.progressBar.getValue() + 1);
    }

    public void close() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setVisible(false);
        this.dispose();
        if (this.isBlocking && this.getParent() != null) {
            this.getParent().setEnabled(true);
        }
    }

    @Override
    public void update(Observable obs, Object obj) {
        try {
            this.setValue((Integer)obj);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

