/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.gui;

import ch.docuteam.tools.os.SystemClipboard;
import ch.docuteam.tools.out.SystemOutRedirectionTarget;
import ch.docuteam.tools.out.SystemOutRedirector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class SystemOutView
extends JFrame
implements SystemOutRedirectionTarget {
    private static final String ScreenTitle = "Console";
    private static Dimension StartScreenSize = new Dimension(600, 400);
    private static SystemOutView SoleInstance;
    private static boolean DoPopUpOnWrite;
    private static String AdditionalInfoText;
    private JTextArea consoleMessagesTextArea = new JTextArea();
    private Action copyAction;

    public SystemOutView() {
        this("<html>An unexpected error occurred. Please copy this message to the system clipboard using the button on the left, then send it to the Dev Team (support@docuteam.ch) together with a brief description of what you did before this happened. Thank you.</html>");
    }

    public SystemOutView(String headerText) {
        super(ScreenTitle);
        this.consoleMessagesTextArea.setEnabled(true);
        this.consoleMessagesTextArea.setEditable(false);
        this.consoleMessagesTextArea.setLineWrap(false);
        this.copyAction = new AbstractAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemOutView.this.copyAction();
            }
        };
        this.copyAction.putValue("ShortDescription", "ctrl-c or cmd-c");
        this.consoleMessagesTextArea.getActionMap().put("Copy", this.copyAction);
        this.consoleMessagesTextArea.getInputMap(2).put(KeyStroke.getKeyStroke(67, 128), "Copy");
        this.consoleMessagesTextArea.getInputMap(2).put(KeyStroke.getKeyStroke(67, 256), "Copy");
        Box topRowBox = new Box(0);
        topRowBox.add(Box.createHorizontalStrut(10));
        topRowBox.add(new JButton(this.copyAction));
        topRowBox.add(Box.createHorizontalStrut(10));
        topRowBox.add(new JLabel(headerText));
        this.add((Component)topRowBox, "North");
        this.add((Component)new JScrollPane(this.consoleMessagesTextArea), "Center");
        this.setPreferredSize(StartScreenSize);
        this.pack();
        this.setLocationRelativeTo(null);
        SoleInstance = this;
    }

    public static void install() {
        SystemOutRedirector.install(new SystemOutView());
    }

    public static void open() {
        if (SoleInstance == null) {
            SoleInstance = new SystemOutView();
        }
        SoleInstance.setVisible(true);
    }

    public static void setDoPopUpOnWrite(boolean doPopUpOnWrite) {
        DoPopUpOnWrite = doPopUpOnWrite;
    }

    public static boolean doPopUpOnWrite() {
        return DoPopUpOnWrite;
    }

    public static void setAdditionalInfoText(String text) {
        AdditionalInfoText = text == null ? "" : text;
    }

    @Override
    public void write(String string) {
        this.consoleMessagesTextArea.append(string);
        if (DoPopUpOnWrite) {
            this.setVisible(true);
        } else {
            this.toFront();
        }
    }

    private void copyAction() {
        SystemClipboard.setText(AdditionalInfoText + this.consoleMessagesTextArea.getText());
    }

    static {
        DoPopUpOnWrite = true;
        AdditionalInfoText = "";
    }
}

