/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.stats;

import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class PackageStatistics {
    private String name;
    private int totalFields = 0;
    private int totalConstructors = 0;
    private int totalMethods = 0;
    private List<ClassStatistics> classesStatistics = new Vector<ClassStatistics>(100);

    public static void main(String ... args) throws ClassNotFoundException, IOException {
        int detailLevel;
        if (args.length != 2) {
            Logger.error("1st parameter (mandatory) must be the package name to probe.");
            Logger.error("2nd parameter (mandatory) is 0 for no output, 1 for brief, 2 for medium, 3 for full.");
            return;
        }
        try {
            detailLevel = new Integer(args[1]);
        }
        catch (NumberFormatException e) {
            Logger.error("Bad number: " + args[1]);
            return;
        }
        PackageStatistics ps = new PackageStatistics(args[0]);
        switch (detailLevel) {
            case 0: {
                break;
            }
            case 1: {
                Logger.info(ps.toStringBrief());
                break;
            }
            case 2: {
                Logger.info(ps.toStringMedium());
                break;
            }
            case 3: {
                Logger.info(ps.toStringFull());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid 2nd parameter: " + detailLevel);
            }
        }
    }

    public PackageStatistics(String name) throws ClassNotFoundException, IOException {
        this.name = name;
        for (Class<?> c : PackageStatistics.getClassesInPackage(name)) {
            try {
                ClassStatistics cs = new ClassStatistics(c);
                this.classesStatistics.add(cs);
                this.totalFields += cs.getFieldsStatistics().size();
                this.totalConstructors += cs.getConstructorsStatistics().size();
                this.totalMethods += cs.getMethodsStatistics().size();
            }
            catch (ClassIsAnonymousException classIsAnonymousException) {}
        }
    }

    private static List<Class<?>> getClassesInPackage(String packageName) throws ClassNotFoundException, IOException {
        String path = packageName.replace('.', '/');
        ArrayList classes = new ArrayList();
        Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources(path);
        while (resources.hasMoreElements()) {
            classes.addAll(PackageStatistics.findClasses(new File(URLDecoder.decode(resources.nextElement().getFile(), "UTF-8")), packageName));
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        Vector classes = new Vector();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : directory.listFiles()) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                classes.addAll(PackageStatistics.findClasses(file, packageName + "." + fileName));
                continue;
            }
            if (!fileName.endsWith(".class")) continue;
            try {
                classes.add(Class.forName(packageName + '.' + fileName.substring(0, fileName.length() - 6)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return classes;
    }

    public String getName() {
        return this.name;
    }

    public List<ClassStatistics> getClassesStatistics() {
        return this.classesStatistics;
    }

    public int getTotalFields() {
        return this.totalFields;
    }

    public int getTotalConstructors() {
        return this.totalConstructors;
    }

    public int getTotalMethods() {
        return this.totalMethods;
    }

    public String toStringFull() {
        StringBuilder string = new StringBuilder(this.toString());
        for (ClassStatistics cs : this.classesStatistics) {
            string.append("\n\t").append(cs.toStringFull());
        }
        string.append("\n\tClasses     : ").append(this.classesStatistics.size());
        string.append("\n\tFields      : ").append(this.totalFields);
        string.append("\n\tConstructors: ").append(this.totalConstructors);
        string.append("\n\tMethods     : ").append(this.totalMethods);
        return string.toString();
    }

    public String toStringMedium() {
        StringBuilder string = new StringBuilder(this.toString());
        for (ClassStatistics cs : this.classesStatistics) {
            string.append("\n\t").append(cs.toStringBrief());
        }
        string.append("\n\tClasses     : ").append(this.classesStatistics.size());
        string.append("\n\tFields      : ").append(this.totalFields);
        string.append("\n\tConstructors: ").append(this.totalConstructors);
        string.append("\n\tMethods     : ").append(this.totalMethods);
        return string.toString();
    }

    public String toStringBrief() {
        StringBuilder string = new StringBuilder(this.toString());
        string.append("\n\tClasses     : ").append(this.classesStatistics.size());
        string.append("\n\tFields      : ").append(this.totalFields);
        string.append("\n\tConstructors: ").append(this.totalConstructors);
        string.append("\n\tMethods     : ").append(this.totalMethods);
        return string.toString();
    }

    public String toString() {
        return "Package: " + this.name;
    }

    private static class ClassIsAnonymousException
    extends Exception {
        private ClassIsAnonymousException(Class<?> cls) {
            super("Can't create statistics for anonymous class: " + cls.getName());
        }
    }

    public static class MethodStatistics {
        private String name;

        private MethodStatistics(Method method) {
            this.name = method.getName();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Method: " + this.name;
        }
    }

    public static class ConstructorStatistics {
        private String name;

        private ConstructorStatistics(Constructor<?> constructor) {
            this.name = constructor.getName();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Constructor: " + this.name;
        }
    }

    public static class FieldStatistics {
        private String name;

        private FieldStatistics(Field field) {
            this.name = field.getName();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Field: " + this.name;
        }
    }

    public static class ClassStatistics {
        private String name;
        private List<FieldStatistics> fieldsStatistics = new Vector<FieldStatistics>(10);
        private List<ConstructorStatistics> constructorsStatistics = new Vector<ConstructorStatistics>(10);
        private List<MethodStatistics> methodsStatistics = new Vector<MethodStatistics>(10);

        private ClassStatistics(Class<?> cls) throws ClassIsAnonymousException {
            if (cls.isAnonymousClass()) {
                throw new ClassIsAnonymousException(cls);
            }
            this.name = cls.getCanonicalName();
            for (Field field : cls.getDeclaredFields()) {
                this.fieldsStatistics.add(new FieldStatistics(field));
            }
            for (AccessibleObject accessibleObject : cls.getDeclaredConstructors()) {
                this.constructorsStatistics.add(new ConstructorStatistics((Constructor)accessibleObject));
            }
            for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
                this.methodsStatistics.add(new MethodStatistics((Method)accessibleObject));
            }
        }

        public String getName() {
            return this.name;
        }

        public List<MethodStatistics> getMethodsStatistics() {
            return this.methodsStatistics;
        }

        public List<ConstructorStatistics> getConstructorsStatistics() {
            return this.constructorsStatistics;
        }

        public List<FieldStatistics> getFieldsStatistics() {
            return this.fieldsStatistics;
        }

        public String toStringFull() {
            StringBuilder string = new StringBuilder(this.toString());
            for (FieldStatistics fs : this.fieldsStatistics) {
                string.append("\n\t\t").append(fs.toString());
            }
            for (ConstructorStatistics cs : this.constructorsStatistics) {
                string.append("\n\t\t").append(cs.toString());
            }
            for (MethodStatistics ms : this.methodsStatistics) {
                string.append("\n\t\t").append(ms.toString());
            }
            string.append("\n\t\tFields      : ").append(this.fieldsStatistics.size());
            string.append("\n\t\tConstructors: ").append(this.constructorsStatistics.size());
            string.append("\n\t\tMethods     : ").append(this.methodsStatistics.size());
            return string.toString();
        }

        public String toStringBrief() {
            StringBuilder string = new StringBuilder(this.toString());
            string.append("\n\t\tFields      : ").append(this.fieldsStatistics.size());
            string.append("\n\t\tConstructors: ").append(this.constructorsStatistics.size());
            string.append("\n\t\tMethods     : ").append(this.methodsStatistics.size());
            return string.toString();
        }

        public String toString() {
            return "Class: " + this.name;
        }
    }
}

