/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.planet.xml.dao;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;
import uk.gov.nationalarchives.droid.planet.xml.dao.GroupByPuidSizeAndCountRow;
import uk.gov.nationalarchives.droid.planet.xml.dao.GroupByYearSizeAndCountRow;
import uk.gov.nationalarchives.droid.planet.xml.dao.PlanetsXMLDao;
import uk.gov.nationalarchives.droid.planet.xml.dao.PlanetsXMLData;
import uk.gov.nationalarchives.droid.planet.xml.dao.ProfileStat;
import uk.gov.nationalarchives.droid.profile.SqlUtils;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public class JdbcPlanetsXMLDaoImpl
implements PlanetsXMLDao {
    private static final int THREE = 3;
    private static final String ZERO = "0";
    private static final int FOLDER_TYPE = 0;
    private static final String SELECT_FORMAT_COUNT = "SELECT COUNT('x') AS TOTAL FROM FORMAT";
    private static final String SELECT_FORMATS = "SELECT PUID, MIME_TYPE, NAME, VERSION FROM FORMAT";
    private static final String SELECT_PRN_COUNT = "SELECT COUNT(*) FROM PROFILE_RESOURCE_NODE p ";
    private static final int FORMAT_MAP_SIZE = 2500;
    private static final String FILTER_FORMAT_SQL_JOIN = " inner join identification i on p.node_id = i.node_id inner join format f on f.puid = i.puid ";
    private static final String TOTAL = "total";
    private static final String AND_RESOURCE_TYPE = "and p.resource_type = ? ";
    private static final String FROM_PROFILE_RESOURCE_NODE = "from profile_resource_node  p ";
    private static final String FILE_COUNT = "file_count";
    private static final String FILE_SIZE = "file_size";
    private static final String WHERE_NODE_STATUS_OR = " where (p.node_status = ? or p.node_status = ?) ";
    private String filterQueryString = "";
    private boolean filterEnabled;
    private boolean formatCriteriaExist;
    private QueryBuilder queryBuilder;
    private final Log log = LogFactory.getLog(this.getClass());
    private DataSource datasource;
    private Connection connection;
    private Map<String, Format> puidFormatMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlanetsXMLData getDataForPlanetsXML(Filter filter) {
        if (this.puidFormatMap == null) {
            List<Format> formats = null;
            try {
                this.puidFormatMap = new HashMap<String, Format>(2500);
                formats = this.loadAllFormats();
            }
            catch (SQLException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            for (Format format : formats) {
                this.puidFormatMap.put(format.getPuid(), format);
            }
        }
        this.filterQueryString = "";
        if (filter != null) {
            String sqlFilter;
            this.filterEnabled = filter.isEnabled() && !filter.getCriteria().isEmpty();
            this.queryBuilder = SqlUtils.getQueryBuilder(filter);
            String ejbFragment = this.queryBuilder.toEjbQl();
            this.filterQueryString = sqlFilter = " and " + SqlUtils.transformEJBtoSQLFields(ejbFragment, "p", "f");
            this.formatCriteriaExist = ejbFragment.contains("format.");
        }
        PlanetsXMLData planetXMLData = null;
        try {
            if (this.puidFormatMap == null) {
                List<Format> formats = this.loadAllFormats();
                this.puidFormatMap = new HashMap<String, Format>(formats.size());
                for (Format format : formats) {
                    this.puidFormatMap.put(format.getPuid(), format);
                }
            }
            this.connection = this.datasource.getConnection();
            planetXMLData = new PlanetsXMLData();
            planetXMLData.setProfileStat(this.getProfileStat());
            planetXMLData.setGroupByPuid(this.getGroupByPuid());
            planetXMLData.setGroupByYear(this.getGroupByYear());
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return planetXMLData;
    }

    private void setFilterParameters(QueryBuilder builder, PreparedStatement profileStatement, int startPosition) throws SQLException {
        int pos = startPosition;
        block6: for (Object value : builder.getValues()) {
            Object value2 = SqlUtils.transformParameterToSQLValue(value);
            String className = value2.getClass().getSimpleName();
            switch (SqlUtils.ClassName.valueOf(className)) {
                case String: {
                    profileStatement.setString(pos++, (String)value2);
                    continue block6;
                }
                case Date: {
                    java.util.Date d = (java.util.Date)value2;
                    profileStatement.setDate(pos++, new Date(d.getTime()));
                    continue block6;
                }
                case Long: {
                    profileStatement.setLong(pos++, (Long)value2);
                    continue block6;
                }
                case Integer: {
                    profileStatement.setInt(pos++, (Integer)value2);
                    continue block6;
                }
                default: {
                    this.log.error((Object)"Invalid filter parameter type in JDBCPlanetsXmlDaoImpl");
                }
            }
        }
    }

    private ProfileStat getProfileStat() throws SQLException {
        ProfileStat profileStat = new ProfileStat();
        StringBuilder sb = new StringBuilder("SELECT   min(p.file_size) as smallest, max(p.file_size) as largest, ");
        sb.append("avg(p.file_size) as mean, sum(p.file_size) as total ");
        sb.append(" from  profile_resource_node p ");
        Statement statement = null;
        ResultSet resultset = null;
        try {
            int paramIndex = 1;
            String whereClause = " where p.resource_type != ?  ";
            if (this.filterEnabled) {
                if (this.filterQueryString.equals("")) {
                    this.log.error((Object)" JDBC Planets XML - Expected to find a filter but it was not found!");
                }
                if (this.formatCriteriaExist) {
                    sb.append(FILTER_FORMAT_SQL_JOIN);
                }
                sb.append(whereClause);
                sb.append(this.filterQueryString);
                statement = this.connection.prepareStatement(sb.toString());
                statement.setInt(paramIndex++, 0);
                this.setFilterParameters(this.queryBuilder, (PreparedStatement)statement, paramIndex);
            } else {
                sb.append(whereClause);
                statement = this.connection.prepareStatement(sb.toString());
                statement.setInt(paramIndex, 0);
            }
            resultset = statement.executeQuery();
            if (resultset.next()) {
                profileStat.setProfileSmallestSize(BigInteger.valueOf(resultset.getInt("smallest")));
                profileStat.setProfileLargestSize(BigInteger.valueOf(resultset.getInt("largest")));
                profileStat.setProfileMeanSize(resultset.getBigDecimal("mean").setScale(1));
                profileStat.setProfileTotalSize(BigInteger.valueOf(resultset.getInt(TOTAL)));
            }
            this.setTotalUnreadableFiles(profileStat);
            this.setTotalUnreadableFolders(profileStat);
            this.setTotalReadableFiles(profileStat);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                if (resultset != null) {
                    resultset.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.log.error((Object)e);
            }
        }
        return profileStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTotalReadableFiles(ProfileStat profileStat) throws SQLException {
        StringBuilder sb = new StringBuilder(SELECT_PRN_COUNT);
        if (this.formatCriteriaExist) {
            sb.append(FILTER_FORMAT_SQL_JOIN);
        }
        sb.append(" where p.node_status NOT IN (?, ?) ");
        sb.append("and  p.resource_type != ? ");
        if (this.filterEnabled && !this.filterQueryString.equals("")) {
            sb.append(this.filterQueryString);
        }
        int index = 1;
        ResultSet resultset = null;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(sb.toString());
            statement.setInt(index++, NodeStatus.ACCESS_DENIED.ordinal());
            statement.setInt(index++, NodeStatus.NOT_FOUND.ordinal());
            statement.setInt(index++, ResourceType.FOLDER.ordinal());
            if (this.filterEnabled && !this.filterQueryString.equals("")) {
                this.setFilterParameters(this.queryBuilder, statement, index);
            }
            if ((resultset = statement.executeQuery()).next()) {
                profileStat.setProfileTotalReadableFiles(BigInteger.valueOf(resultset.getInt(1)));
            }
        }
        finally {
            if (resultset != null) {
                resultset.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTotalUnreadableFolders(ProfileStat profileStat) throws SQLException {
        StringBuilder sb = new StringBuilder(SELECT_PRN_COUNT);
        if (this.formatCriteriaExist) {
            sb.append(FILTER_FORMAT_SQL_JOIN);
        }
        sb.append(WHERE_NODE_STATUS_OR);
        sb.append(AND_RESOURCE_TYPE);
        if (this.filterEnabled && !this.filterQueryString.equals("")) {
            sb.append(this.filterQueryString);
        }
        int index = 1;
        ResultSet resultset = null;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(sb.toString());
            statement.setInt(index++, NodeStatus.ACCESS_DENIED.ordinal());
            statement.setInt(index++, NodeStatus.NOT_FOUND.ordinal());
            statement.setInt(index++, ResourceType.FOLDER.ordinal());
            if (this.filterEnabled && !this.filterQueryString.equals("")) {
                this.setFilterParameters(this.queryBuilder, statement, index);
            }
            if ((resultset = statement.executeQuery()).next()) {
                profileStat.setProfileTotalUnReadableFolders(BigInteger.valueOf(resultset.getInt(1)));
            }
        }
        finally {
            if (resultset != null) {
                resultset.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTotalUnreadableFiles(ProfileStat profileStat) throws SQLException {
        StringBuilder sb = new StringBuilder(SELECT_PRN_COUNT);
        if (this.formatCriteriaExist) {
            sb.append(FILTER_FORMAT_SQL_JOIN);
        }
        sb.append(WHERE_NODE_STATUS_OR);
        sb.append("and p.resource_type != ? ");
        if (this.filterEnabled && !this.filterQueryString.equals("")) {
            sb.append(this.filterQueryString);
        }
        int index = 1;
        ResultSet resultset = null;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(sb.toString());
            statement.setInt(index++, NodeStatus.ACCESS_DENIED.ordinal());
            statement.setInt(index++, NodeStatus.NOT_FOUND.ordinal());
            statement.setInt(index++, ResourceType.FOLDER.ordinal());
            if (this.filterEnabled && !this.filterQueryString.equals("")) {
                this.setFilterParameters(this.queryBuilder, statement, index);
            }
            if ((resultset = statement.executeQuery()).next()) {
                profileStat.setProfileTotalUnReadableFiles(BigInteger.valueOf(resultset.getInt(1)));
            }
        }
        finally {
            if (resultset != null) {
                resultset.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GroupByYearSizeAndCountRow> getGroupByYear() throws SQLException {
        ArrayList<GroupByYearSizeAndCountRow> dataList = new ArrayList<GroupByYearSizeAndCountRow>();
        GroupByYearSizeAndCountRow groupByYearSizeAndCountRow = null;
        StringBuilder sb = new StringBuilder("SELECT year(p.last_modified_date) as file_year, ");
        sb.append("count(*) as file_count, sum(p.file_size) as file_size ");
        sb.append(FROM_PROFILE_RESOURCE_NODE);
        if (this.formatCriteriaExist) {
            sb.append(FILTER_FORMAT_SQL_JOIN);
        }
        sb.append("where p.resource_type != ? ");
        if (this.filterEnabled && !this.filterQueryString.equals("")) {
            sb.append(this.filterQueryString);
        }
        sb.append(" group by year(p.last_modified_date)");
        int index = 1;
        ResultSet resultset = null;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(sb.toString());
            statement.setInt(index++, ResourceType.FOLDER.ordinal());
            if (this.filterEnabled && !this.filterQueryString.equals("")) {
                this.setFilterParameters(this.queryBuilder, statement, index);
            }
            resultset = statement.executeQuery();
            while (resultset.next()) {
                groupByYearSizeAndCountRow = new GroupByYearSizeAndCountRow();
                groupByYearSizeAndCountRow.setYear(resultset.getInt("file_year"));
                groupByYearSizeAndCountRow.setCount(BigInteger.valueOf(resultset.getLong(FILE_COUNT)));
                groupByYearSizeAndCountRow.setSize(resultset.getBigDecimal(FILE_SIZE).setScale(1));
                dataList.add(groupByYearSizeAndCountRow);
            }
        }
        finally {
            if (resultset != null) {
                resultset.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GroupByPuidSizeAndCountRow> getGroupByPuid() throws SQLException {
        ArrayList<GroupByPuidSizeAndCountRow> dataList = new ArrayList<GroupByPuidSizeAndCountRow>();
        GroupByPuidSizeAndCountRow groupByPuidSizeAndCountRow = null;
        StringBuilder sb = new StringBuilder("SELECT f.puid, count(*) as file_count, sum(p.file_size) as file_size ");
        sb.append(FROM_PROFILE_RESOURCE_NODE);
        sb.append(FILTER_FORMAT_SQL_JOIN);
        sb.append(" where p.resource_type != ? ");
        if (this.filterEnabled && !this.filterQueryString.equals("")) {
            sb.append(this.filterQueryString);
        }
        sb.append(" group by f.puid ");
        int index = 1;
        ResultSet resultset = null;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(sb.toString());
            statement.setInt(index++, ResourceType.FOLDER.ordinal());
            if (this.filterEnabled && !this.filterQueryString.equals("")) {
                this.setFilterParameters(this.queryBuilder, statement, index);
            }
            resultset = statement.executeQuery();
            while (resultset.next()) {
                groupByPuidSizeAndCountRow = new GroupByPuidSizeAndCountRow();
                String puid = resultset.getString("puid");
                BigInteger fileCount = BigInteger.valueOf(resultset.getLong(FILE_COUNT));
                groupByPuidSizeAndCountRow.setCount(fileCount);
                BigDecimal fileSize = resultset.getBigDecimal(FILE_SIZE).setScale(1);
                groupByPuidSizeAndCountRow.setSize(fileSize);
                Format format = this.puidFormatMap.get(puid);
                groupByPuidSizeAndCountRow.setFormatName(format.getName());
                groupByPuidSizeAndCountRow.setFormatVersion(format.getVersion());
                groupByPuidSizeAndCountRow.setMimeType(format.getMimeType());
                dataList.add(groupByPuidSizeAndCountRow);
            }
        }
        finally {
            if (resultset != null) {
                resultset.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return dataList;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Format> loadAllFormats() throws SQLException {
        ArrayList<Format> formats = null;
        try (Connection conn = this.datasource.getConnection();){
            PreparedStatement getFormatCount = conn.prepareStatement(SELECT_FORMAT_COUNT);
            ResultSet rsFormatCount = getFormatCount.executeQuery();
            rsFormatCount.next();
            int formatCount = rsFormatCount.getInt(TOTAL);
            formats = new ArrayList<Format>(formatCount);
            try (PreparedStatement loadFormat = conn.prepareStatement(SELECT_FORMATS);
                 ResultSet results = loadFormat.executeQuery();){
                while (results.next()) {
                    formats.add(SqlUtils.buildFormat(results));
                }
            }
        }
        return formats;
    }
}

