/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.profile.ProfileDiskAction;
import uk.gov.nationalarchives.droid.profile.ProfileException;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceLocator;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceManager;
import uk.gov.nationalarchives.droid.profile.ProfileState;
import uk.gov.nationalarchives.droid.results.handlers.JDBCBatchResultHandlerDao;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class ProfileContextLocator {
    private static final String HIBERNATE_GENERATE_DDL = "hibernate.generateDdl";
    private static final String DATABASE_URL = "datasource.url";
    private static final String CREATE_URL = "datasource.createUrl";
    private static final String HIBERNATE_CREATE = "hibernate.hbm2ddl.auto";
    private static final String BLANK_PROFILE = "profile.template";
    private static final String SIG_PROFILE = "profile\\.\\d+\\.template";
    private final Log log = LogFactory.getLog(this.getClass());
    private DroidGlobalConfig globalConfig;
    private Map<String, ProfileInstance> profileInstances = LazyMap.decorate(new HashMap(), (Transformer)new ProfileTransformer());
    private ProfileInstanceLocator profileInstanceLocator;

    public ProfileInstance getProfileInstance(String id) {
        return this.profileInstances.get(id);
    }

    public void addProfileContext(ProfileInstance profileInstance) {
        this.profileInstances.put(profileInstance.getUuid(), profileInstance);
    }

    public void removeProfileContext(String id) {
        this.profileInstances.remove(id);
        this.profileInstanceLocator.closeProfileInstance(id);
    }

    public void freezeDatabase(String profileId) {
        this.profileInstanceLocator.freezeDatabase(profileId);
    }

    public void thawDatabase(String profileId) {
        this.profileInstanceLocator.thawDatabase(profileId);
    }

    public ProfileInstanceManager openProfileInstanceManager(ProfileInstance profile) {
        boolean newDatabase;
        File profileHome = new File(this.globalConfig.getProfilesDir(), profile.getUuid());
        File databasePath = new File(profileHome, "/db");
        File signatureFile = new File(profileHome, profile.getSignatureFileName());
        File containerSignatureFile = new File(profileHome, profile.getContainerSignatureFileName());
        File submissionQueueFile = new File(profileHome, "submissionQueue.xml");
        Properties props = new Properties();
        props.setProperty("defaultThrottle", String.valueOf(profile.getThrottle()));
        props.setProperty("signatureFilePath", signatureFile.getPath());
        props.setProperty("submissionQueueFile", submissionQueueFile.getPath());
        props.setProperty("tempDirLocation", this.globalConfig.getTempDir().getPath());
        props.setProperty("profileHome", profileHome.getPath());
        props.setProperty("containerSigPath", containerSignatureFile.getPath());
        props.setProperty("processArchives", String.valueOf(profile.getProcessArchiveFiles()));
        props.setProperty("processWebArchives", String.valueOf(profile.getProcessWebArchiveFiles()));
        props.setProperty("generateHash", String.valueOf(profile.getGenerateHash()));
        props.setProperty("hashAlgorithm", String.valueOf(profile.getHashAlgorithm()));
        props.setProperty("maxBytesToScan", String.valueOf(profile.getMaxBytesToScan()));
        props.setProperty("matchAllExtensions", String.valueOf(profile.getMatchAllExtensions()));
        String createUrl = this.globalConfig.getProperties().getString("database.createUrl");
        if (createUrl == null || createUrl.isEmpty()) {
            createUrl = "{none}";
        }
        props.setProperty(CREATE_URL, createUrl);
        props.setProperty(DATABASE_URL, String.format("jdbc:derby:%s", databasePath.getPath()));
        TemplateStatus status = null;
        boolean bl = newDatabase = !databasePath.exists();
        if (newDatabase) {
            File profileTemplate = this.getProfileTemplateFile(profile);
            status = this.getTemplateStatus(profileTemplate);
            status = this.setupDatabaseTemplate(status, profileTemplate, databasePath, props);
        }
        if (status == TemplateStatus.NO_TEMPLATE) {
            JDBCBatchResultHandlerDao.setIsFreshTemplate(true);
        }
        ProfileInstanceManager profileManager = this.profileInstanceLocator.getProfileInstanceManager(profile, props);
        JDBCBatchResultHandlerDao.setIsFreshTemplate(false);
        if (newDatabase) {
            this.generateNewDatabaseAndTemplates(profile, profileManager, databasePath, signatureFile, status);
        }
        return profileManager;
    }

    private void setCreateSchemaProperties(boolean create, Properties props) {
        if (create) {
            props.setProperty(HIBERNATE_GENERATE_DDL, "true");
            props.setProperty(HIBERNATE_CREATE, "create");
        } else {
            props.setProperty(HIBERNATE_CREATE, "none");
            props.setProperty(HIBERNATE_GENERATE_DDL, "false");
        }
    }

    private TemplateStatus setupDatabaseTemplate(TemplateStatus status, File profileTemplate, File databasePath, Properties props) {
        TemplateStatus result = status;
        if (status != TemplateStatus.NO_TEMPLATE) {
            try {
                this.unpackProfileTemplate(profileTemplate, databasePath);
            }
            catch (IOException e) {
                this.log.error((Object)e);
                result = TemplateStatus.NO_TEMPLATE;
            }
        }
        return result;
    }

    private void generateNewDatabaseAndTemplates(ProfileInstance profile, ProfileInstanceManager profileManager, File databasePath, File signatureFile, TemplateStatus status) {
        if (status == TemplateStatus.NO_TEMPLATE) {
            this.freezeDatabase(profile.getUuid());
            this.packProfileTemplate(databasePath, this.getTemplateFile(BLANK_PROFILE));
            this.thawDatabase(profile.getUuid());
        }
        if (status != TemplateStatus.SIGNATURE_TEMPLATE) {
            try {
                profileManager.initProfile(signatureFile.toURI());
                String name = this.getTemplateNameForSignatureVersion(profile.getSignatureFileVersion());
                File templateFile = this.getTemplateFile(name);
                this.freezeDatabase(profile.getUuid());
                this.packProfileTemplate(databasePath, templateFile);
                this.thawDatabase(profile.getUuid());
            }
            catch (SignatureFileException e) {
                String message = "Error reading signature file";
                this.log.error((Object)message, (Throwable)e);
                throw new ProfileException(message, e);
            }
        }
    }

    private TemplateStatus getTemplateStatus(File profileTemplateFile) {
        TemplateStatus status = TemplateStatus.NO_TEMPLATE;
        if (profileTemplateFile != null) {
            if (BLANK_PROFILE.equals(profileTemplateFile.getName())) {
                status = TemplateStatus.BLANK_TEMPLATE;
            } else if (profileTemplateFile.getName().matches(SIG_PROFILE)) {
                status = TemplateStatus.SIGNATURE_TEMPLATE;
            }
        }
        return status;
    }

    private File getProfileTemplateFile(ProfileInstance profile) {
        String sigTemplateName = this.getTemplateNameForSignatureVersion(profile.getSignatureFileVersion());
        File profileTemplate = this.getTemplateFile(sigTemplateName);
        if (!profileTemplate.exists() && !(profileTemplate = this.getTemplateFile(BLANK_PROFILE)).exists()) {
            profileTemplate = null;
        }
        return profileTemplate;
    }

    private String getTemplateNameForSignatureVersion(Integer signatureVersion) {
        return String.format("profile.%d.template", signatureVersion);
    }

    private File getTemplateFile(String templateFileName) {
        File templateDir = this.globalConfig.getProfileTemplateDir();
        return new File(templateDir, templateFileName);
    }

    private void unpackProfileTemplate(File profileTemplate, File copyToDirectory) throws IOException {
        copyToDirectory.mkdir();
        ProfileDiskAction unpacker = new ProfileDiskAction();
        ProgressObserver observe = new ProgressObserver(){

            @Override
            public void onProgress(Integer progress) {
            }
        };
        unpacker.load(profileTemplate, copyToDirectory, observe);
    }

    private void packProfileTemplate(File databaseDir, File profileTemplate) {
        ProfileDiskAction packer = new ProfileDiskAction();
        ProgressObserver observe = new ProgressObserver(){

            @Override
            public void onProgress(Integer progress) {
            }
        };
        try {
            packer.saveProfile(databaseDir.getPath(), profileTemplate, observe);
        }
        catch (IOException e) {
            this.log.error((Object)e);
        }
    }

    public void setProfileInstanceLocator(ProfileInstanceLocator profileInstanceLocator) {
        this.profileInstanceLocator = profileInstanceLocator;
    }

    public boolean hasProfileContext(String profileName) {
        return this.profileInstances.containsKey(profileName);
    }

    public void setGlobalConfig(DroidGlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    private final class ProfileTransformer
    implements Transformer {
        private ProfileTransformer() {
        }

        public Object transform(Object id) {
            ProfileInstance profileInstance = new ProfileInstance(ProfileState.INITIALISING);
            profileInstance.setUuid((String)id);
            profileInstance.setThrottle(ProfileContextLocator.this.globalConfig.getProperties().getInt(DroidGlobalProperty.DEFAULT_THROTTLE.getName()));
            profileInstance.setHashAlgorithm(ProfileContextLocator.this.globalConfig.getProperties().getString(DroidGlobalProperty.HASH_ALGORITHM.getName()));
            profileInstance.setGenerateHash(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.GENERATE_HASH.getName()));
            profileInstance.setProcessArchiveFiles(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_ARCHIVES.getName()));
            profileInstance.setProcessWebArchiveFiles(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_WEB_ARCHIVES.getName()));
            profileInstance.setMaxBytesToScan(ProfileContextLocator.this.globalConfig.getProperties().getLong(DroidGlobalProperty.MAX_BYTES_TO_SCAN.getName()));
            profileInstance.setMatchAllExtensions(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.EXTENSION_ALL.getName()));
            return profileInstance;
        }
    }

    private static enum TemplateStatus {
        NO_TEMPLATE,
        BLANK_TEMPLATE,
        SIGNATURE_TEMPLATE;

    }
}

