/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.io.File;
import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.profile.AbstractProfileResource;
import uk.gov.nationalarchives.droid.profile.FilterImpl;
import uk.gov.nationalarchives.droid.profile.ProfileEventListener;
import uk.gov.nationalarchives.droid.profile.ProfileSpec;
import uk.gov.nationalarchives.droid.profile.ProfileState;
import uk.gov.nationalarchives.droid.profile.ProgressState;

@XmlRootElement(name="Profile")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProfileInstance {
    private static final Log LOG = LogFactory.getLog(ProfileInstance.class);
    @XmlAttribute(name="Id")
    private String uuid;
    @XmlElement(name="CreatedDate", required=true)
    private Date dateCreated;
    @XmlElement(name="Name", required=true)
    private String name;
    @XmlElement(name="ProfileSpec", required=true)
    private ProfileSpec profileSpec;
    @XmlElement(name="State", required=true)
    private ProfileState profileState;
    @XmlElement(name="SignatureFileVersion", required=true)
    private Integer signatureFileVersion;
    @XmlElement(name="ContainerSignatureFileVersion", required=true)
    private Integer containerSignatureFileVersion;
    @XmlElement(name="TextSignatureFileVersion", required=false)
    private Integer textSignatureFileVersion;
    @XmlTransient
    private File loadedFrom;
    @XmlTransient
    private boolean dirty = true;
    @XmlElement(name="Filter", required=true)
    private FilterImpl filter;
    @XmlElement(name="Throttle")
    private int throttle;
    @XmlElement(name="SignatureFileName")
    private String signatureFileName;
    @XmlElement(name="ContainerSignatureFileName")
    private String containerSignatureFileName;
    @XmlElement(name="TextSignatureFileName")
    private String textSignatureFileName;
    @XmlElement(name="EndDate")
    private Date profileEndDate;
    @XmlElement(name="StartDate")
    private Date profileStartDate;
    @XmlTransient
    private ProfileState transientState;
    @XmlElement(name="Progress")
    private ProgressState progress;
    @XmlElement(name="GenerateHash")
    private Boolean generateHash;
    @XmlElement(name="HashAlgorithm")
    private String hashAlgorithm;
    @XmlElement(name="ProcessArchiveFiles")
    private Boolean processArchiveFiles;
    @XmlElement(name="ProcessWebArchiveFiles")
    private Boolean processWebArchiveFiles;
    @XmlElement(name="MaxBytesToScan")
    private Long maxBytesToScan;
    @XmlElement(name="MatchAllExtensions")
    private Boolean matchAllExtensions;
    @XmlTransient
    private Set<ProfileEventListener> eventListeners = new HashSet<ProfileEventListener>();

    ProfileInstance(ProfileState state) {
        this();
        this.transientState = state;
    }

    ProfileInstance() {
        this.dateCreated = new Date();
    }

    public FilterImpl getFilter() {
        if (this.filter == null) {
            this.filter = new FilterImpl();
        }
        return this.filter;
    }

    public void setFilter(FilterImpl filter) {
        this.filter = filter;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public String getUuid() {
        return this.uuid;
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ProfileSpec getProfileSpec() {
        return this.profileSpec;
    }

    public void setProfileSpec(ProfileSpec profileSpec) {
        this.profileSpec = profileSpec;
        this.dirty = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean addResource(AbstractProfileResource resource) {
        boolean success = this.profileSpec.addResource(resource);
        if (success) {
            this.dirty = true;
            this.fireListeners();
        }
        return success;
    }

    public boolean removeResource(URI uri) {
        boolean success = this.profileSpec.removeResource(uri);
        if (success) {
            this.dirty = true;
            this.fireListeners();
        }
        return success;
    }

    void start() {
        this.setProfileStartDate(new Date());
        this.changeState(ProfileState.RUNNING);
        this.dirty = true;
    }

    void finish() {
        this.setProfileEndDate(new Date());
        this.changeState(ProfileState.FINISHED);
    }

    void stop() {
        this.changeState(ProfileState.STOPPED);
    }

    public void changeState(ProfileState newState) {
        LOG.info((Object)String.format("Attempting state change [%s] to [%s]", new Object[]{this.getState(), newState}));
        if (!this.getState().allowedNextStates().contains((Object)newState)) {
            throw new IllegalStateException(String.format("Illegal attempt to transition state from [%s] to [%s]", new Object[]{this.getState(), newState}));
        }
        if (newState.isTransient()) {
            this.transientState = newState;
        } else {
            this.transientState = null;
            this.profileState = newState;
        }
        this.fireListeners();
    }

    void fireListeners() {
        for (ProfileEventListener listener : this.eventListeners) {
            listener.fireEvent(this);
        }
    }

    public Integer getSignatureFileVersion() {
        return this.signatureFileVersion;
    }

    public void setSignatureFileVersion(Integer signatureFileVersion) {
        this.signatureFileVersion = signatureFileVersion;
    }

    public File getLoadedFrom() {
        return this.loadedFrom;
    }

    public void setLoadedFrom(File loadedFrom) {
        this.loadedFrom = loadedFrom;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public ProfileState getState() {
        return this.transientState != null ? this.transientState : this.profileState;
    }

    public void onLoad() {
        this.dirty = false;
        this.fireListeners();
    }

    public void onSave() {
        this.dirty = false;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.fireListeners();
    }

    void setThrottle(int throttle) {
        this.throttle = throttle;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public String getSignatureFileName() {
        return this.signatureFileName;
    }

    public void setSignatureFileName(String signatureFileName) {
        this.signatureFileName = signatureFileName;
    }

    public Date getProfileEndDate() {
        return this.profileEndDate;
    }

    public void setProfileEndDate(Date profileEndDate) {
        this.profileEndDate = profileEndDate;
    }

    public Date getProfileStartDate() {
        return this.profileStartDate;
    }

    public void setProfileStartDate(Date profileStartDate) {
        this.profileStartDate = profileStartDate;
    }

    public void addEventListener(ProfileEventListener listener) {
        this.eventListeners.add(listener);
    }

    public ProgressState getProgress() {
        return this.progress;
    }

    public void setProgress(ProgressState progress) {
        this.progress = progress;
    }

    public void setContainerSignatureFileName(String containerSignatureFileName) {
        this.containerSignatureFileName = containerSignatureFileName;
    }

    public void setContainerSignatureFileVersion(Integer containerSignatureFileVersion) {
        this.containerSignatureFileVersion = containerSignatureFileVersion;
    }

    public void setTextSignatureFileName(String textSignatureFileName) {
        this.textSignatureFileName = textSignatureFileName;
    }

    public void setTextSignatureFileVersion(Integer textSignatureFileVersion) {
        this.textSignatureFileVersion = textSignatureFileVersion;
    }

    public String getContainerSignatureFileName() {
        return this.containerSignatureFileName;
    }

    public Integer getContainerSignatureFileVersion() {
        return this.containerSignatureFileVersion;
    }

    public String getTextSignatureFileName() {
        return this.textSignatureFileName;
    }

    public Integer getTextSignatureFileVersion() {
        return this.textSignatureFileVersion;
    }

    public Boolean getGenerateHash() {
        return this.generateHash;
    }

    public void setGenerateHash(boolean generateHash) {
        this.generateHash = generateHash;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public Boolean getProcessArchiveFiles() {
        return this.processArchiveFiles;
    }

    public Boolean getProcessWebArchiveFiles() {
        return this.processWebArchiveFiles;
    }

    public void setProcessArchiveFiles(boolean processArchiveFiles) {
        this.processArchiveFiles = processArchiveFiles;
    }

    public void setProcessWebArchiveFiles(boolean processWebArchiveFiles) {
        this.processWebArchiveFiles = processWebArchiveFiles;
    }

    public Long getMaxBytesToScan() {
        return this.maxBytesToScan;
    }

    public void setMaxBytesToScan(long maxBytesToScan) {
        this.maxBytesToScan = maxBytesToScan;
    }

    public void setMatchAllExtensions(Boolean matchAllExtensions) {
        this.matchAllExtensions = matchAllExtensions;
    }

    public Boolean getMatchAllExtensions() {
        return this.matchAllExtensions;
    }
}

