/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManager;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;
import uk.gov.nationalarchives.droid.profile.ProfileContextLocator;
import uk.gov.nationalarchives.droid.profile.ProfileDiskAction;
import uk.gov.nationalarchives.droid.profile.ProfileException;
import uk.gov.nationalarchives.droid.profile.ProfileFileHelper;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceManager;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileManagerException;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.ProfileResultObserver;
import uk.gov.nationalarchives.droid.profile.ProfileSpec;
import uk.gov.nationalarchives.droid.profile.ProfileSpecDao;
import uk.gov.nationalarchives.droid.profile.ProfileState;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.profile.referencedata.ReferenceData;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class ProfileManagerImpl
implements ProfileManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private ProfileContextLocator profileContextLocator;
    private ProfileSpecDao profileSpecDao;
    private ProfileDiskAction profileSaver;
    private SignatureManager signatureManager;
    private DroidGlobalConfig config;

    @Override
    public ProfileInstance createProfile(Map<SignatureType, SignatureFileInfo> sigFileInfos) throws ProfileManagerException {
        SignatureFileInfo textSigFile;
        SignatureFileInfo containerSigFile;
        Map signatures = sigFileInfos;
        if (sigFileInfos == null) {
            try {
                signatures = this.signatureManager.getDefaultSignatures();
            }
            catch (SignatureFileException e) {
                throw new ProfileManagerException(e.getMessage());
            }
        }
        String profileId = String.valueOf(System.currentTimeMillis());
        this.log.info((Object)("Creating profile: " + profileId));
        ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
        File profileHomeDir = new File(this.config.getProfilesDir(), profile.getUuid());
        profileHomeDir.mkdir();
        SignatureFileInfo binarySigFile = (SignatureFileInfo)signatures.get(SignatureType.BINARY);
        if (binarySigFile != null) {
            profile.setSignatureFileVersion(binarySigFile.getVersion());
            profile.setSignatureFileName(binarySigFile.getFile().getName());
            ProfileManagerImpl.copySignatureFile(binarySigFile.getFile(), profileHomeDir);
        }
        if ((containerSigFile = (SignatureFileInfo)signatures.get(SignatureType.CONTAINER)) != null) {
            profile.setContainerSignatureFileName(containerSigFile.getFile().getName());
            profile.setContainerSignatureFileVersion(containerSigFile.getVersion());
            ProfileManagerImpl.copySignatureFile(containerSigFile.getFile(), profileHomeDir);
        }
        if ((textSigFile = (SignatureFileInfo)signatures.get(SignatureType.TEXT)) != null) {
            profile.setTextSignatureFileName(textSigFile.getFile().getName());
            profile.setTextSignatureFileVersion(textSigFile.getVersion());
            ProfileManagerImpl.copySignatureFile(textSigFile.getFile(), profileHomeDir);
        }
        profile.setUuid(profileId);
        profile.setProfileSpec(new ProfileSpec());
        this.profileSpecDao.saveProfile(profile, profileHomeDir);
        profile.setDirty(false);
        this.profileContextLocator.addProfileContext(profile);
        return profile;
    }

    private static void copySignatureFile(File file, File destDir) {
        try {
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
        catch (IOException e) {
            throw new ProfileException(e.getMessage(), e);
        }
    }

    @Override
    public void closeProfile(String profileName) {
        this.log.info((Object)("Closing profile: " + profileName));
        this.profileContextLocator.removeProfileContext(profileName);
        if (!this.config.getProperties().getBoolean(DroidGlobalProperty.DEV_MODE.getName())) {
            File profileHome = new File(this.config.getProfilesDir(), profileName);
            FileUtils.deleteQuietly((File)profileHome);
        }
    }

    @Override
    public ProfileInstance openProfile(String profileId) {
        this.log.info((Object)("Opening profile: " + profileId));
        if (!this.profileContextLocator.hasProfileContext(profileId)) {
            throw new IllegalArgumentException(String.format("No such profile id [%s]", profileId));
        }
        ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
        this.profileContextLocator.openProfileInstanceManager(profile);
        profile.fireListeners();
        return profile;
    }

    @Override
    public void stop(String profileInstance) {
        this.log.info((Object)("Stopping profile: " + profileInstance));
        ProfileInstanceManager profileInstanceManager = this.getProfileInstanceManager(profileInstance);
        profileInstanceManager.pause();
    }

    private ProfileInstanceManager getProfileInstanceManager(String profileInstance) {
        if (profileInstance == null) {
            String message = "Profile instance id was null";
            this.log.error((Object)message);
            throw new ProfileException(message);
        }
        ProfileInstanceManager profileInstanceManager = this.profileContextLocator.openProfileInstanceManager(this.profileContextLocator.getProfileInstance(profileInstance));
        return profileInstanceManager;
    }

    @Override
    public Future<?> start(String profileId) throws IOException {
        this.log.info((Object)("Starting profile: " + profileId));
        ProfileInstanceManager profileInstanceManager = this.getProfileInstanceManager(profileId);
        return profileInstanceManager.start();
    }

    @Override
    public List<ProfileResourceNode> findProfileResourceNodeAndImmediateChildren(String profileId, Long parentId) {
        this.log.debug((Object)String.format(" **** Called findProfileResourceNodeAndImmediateChildren [%s] ****", profileId));
        ProfileInstanceManager profileInstanceManager = this.getProfileInstanceManager(profileId);
        return profileInstanceManager.findAllProfileResourceNodes(parentId);
    }

    @Override
    public List<ProfileResourceNode> findRootNodes(String profileId) {
        ProfileInstanceManager profileInstanceManager = this.getProfileInstanceManager(profileId);
        return profileInstanceManager.findRootProfileResourceNodes();
    }

    @Override
    public void setProgressObserver(String profileId, ProgressObserver progressObserver) {
        ProfileInstanceManager profileInstanceManager = this.getProfileInstanceManager(profileId);
        profileInstanceManager.getProgressMonitor().setPercentIncrementObserver(progressObserver);
    }

    public void setProfileSpecDao(ProfileSpecDao profileSpecDao) {
        this.profileSpecDao = profileSpecDao;
    }

    public void setProfileContextLocator(ProfileContextLocator profileContextLocator) {
        this.profileContextLocator = profileContextLocator;
    }

    @Override
    public void setResultsObserver(String profileUuid, ProfileResultObserver observer) {
        this.getProfileInstanceManager(profileUuid).setResultsObserver(observer);
    }

    @Override
    public void updateProfileSpec(String profileId, ProfileSpec profileSpec) {
        ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
        profile.setProfileSpec(profileSpec);
        this.profileSpecDao.saveProfile(profile, this.getProfileHomeDir(profile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileInstance save(String profileId, File destination, ProgressObserver callback) throws IOException {
        this.log.info((Object)("Saving profile: " + profileId + " to " + destination.getPath()));
        this.profileContextLocator.freezeDatabase(profileId);
        ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
        ProfileState oldState = profile.getState();
        profile.changeState(ProfileState.SAVING);
        try {
            File output = destination != null ? destination : profile.getLoadedFrom();
            this.profileSpecDao.saveProfile(profile, this.getProfileHomeDir(profile));
            this.profileSaver.saveProfile(this.getProfileHomeDir(profile).getPath(), output, callback);
            profile.setLoadedFrom(output);
            profile.setName(FilenameUtils.getBaseName((String)output.getName()));
            profile.onSave();
        }
        finally {
            this.profileContextLocator.thawDatabase(profileId);
            profile.changeState(oldState);
        }
        return profile;
    }

    public void setProfileDiskAction(ProfileDiskAction profileDiskAction) {
        this.profileSaver = profileDiskAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileInstance open(File source, ProgressObserver observer) throws IOException {
        ProfileInstance profile;
        this.log.info((Object)("Loading profile from: " + source.getPath()));
        ZipFile sourceZip = new ZipFile(source);
        InputStream in = ProfileFileHelper.getProfileXmlInputStream(sourceZip);
        try {
            profile = this.profileSpecDao.loadProfile(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
            sourceZip.close();
        }
        profile.setLoadedFrom(source);
        profile.setName(FilenameUtils.getBaseName((String)source.getName()));
        profile.setUuid(String.valueOf(System.currentTimeMillis()));
        profile.onLoad();
        String profileId = profile.getUuid();
        if (!this.profileContextLocator.hasProfileContext(profileId)) {
            this.profileContextLocator.addProfileContext(profile);
            File destination = this.getProfileHomeDir(profile);
            this.profileSaver.load(source, destination, observer);
            this.profileSpecDao.saveProfile(profile, this.getProfileHomeDir(profile));
            this.profileContextLocator.openProfileInstanceManager(profile);
        }
        return profile;
    }

    @Override
    public List<Format> getAllFormats(String profileId) {
        return this.getProfileInstanceManager(profileId).getAllFormats();
    }

    @Override
    public ReferenceData getReferenceData(String profileId) {
        return this.getProfileInstanceManager(profileId).getReferenceData();
    }

    @Override
    public void setThrottleValue(String uuid, int value) {
        this.getProfileInstanceManager(uuid).setThrottleValue(value);
    }

    public void setSignatureManager(SignatureManager signatureManager) {
        this.signatureManager = signatureManager;
    }

    public void setConfig(DroidGlobalConfig config) {
        this.config = config;
    }

    private File getProfileHomeDir(ProfileInstance profile) {
        return new File(this.config.getProfilesDir(), profile.getUuid());
    }
}

