/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import uk.gov.nationalarchives.droid.profile.AbstractProfileResource;
import uk.gov.nationalarchives.droid.profile.DirectoryProfileResource;
import uk.gov.nationalarchives.droid.profile.FileProfileResource;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ProfileSpec {
    static final int NAME_MAX_LENGTH = 255;
    static final int DESC_MAX_LENGTH = 255;
    @XmlElementWrapper(name="Resources", required=true)
    @XmlElementRefs(value={@XmlElementRef(name="File", type=FileProfileResource.class), @XmlElementRef(name="Dir", type=DirectoryProfileResource.class)})
    private List<AbstractProfileResource> resources = new ArrayList<AbstractProfileResource>();
    private Map<URI, AbstractProfileResource> resourceMap = new HashMap<URI, AbstractProfileResource>();

    boolean addResource(AbstractProfileResource resource) {
        if (this.resources.contains(resource)) {
            return false;
        }
        this.resources.add(resource);
        this.resourceMap.put(resource.getUri(), resource);
        return true;
    }

    public List<AbstractProfileResource> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    boolean removeResource(URI uri) {
        return this.resources.remove(this.resourceMap.remove(uri));
    }
}

