/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report.dao;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;
import uk.gov.nationalarchives.droid.profile.SqlUtils;
import uk.gov.nationalarchives.droid.report.dao.GroupByField;
import uk.gov.nationalarchives.droid.report.dao.ReportDao;
import uk.gov.nationalarchives.droid.report.dao.ReportFieldEnum;
import uk.gov.nationalarchives.droid.report.dao.ReportFieldType;
import uk.gov.nationalarchives.droid.report.dao.ReportLineItem;

public class SqlReportDaoImpl
implements ReportDao {
    private static String formatfilter = "formatfilter";
    private final Log log = LogFactory.getLog(this.getClass());
    private DataSource datasource;

    void flush() {
    }

    @Override
    public List<ReportLineItem> getReportData(Criterion filter, ReportFieldEnum reportField) {
        return this.getReportData(filter, reportField, new ArrayList<GroupByField>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReportLineItem> getReportData(Criterion filter, ReportFieldEnum reportField, List<GroupByField> groupByFields) {
        PreparedStatement statement = null;
        ResultSet resultset = null;
        Connection connection = null;
        String sqlQuery = this.getQueryString(reportField, groupByFields, filter);
        try {
            connection = this.datasource.getConnection();
            statement = connection.prepareStatement(sqlQuery);
            this.setFilterParameters(statement, filter);
            resultset = statement.executeQuery();
            ArrayList<ReportLineItem> reportData = new ArrayList();
            ArrayList<ReportLineItem> arrayList = reportData = reportField.getType().populateReportedData(resultset);
            return arrayList;
        }
        catch (SQLException ex) {
            this.log.error((Object)"Error executing report query", (Throwable)ex);
        }
        finally {
            try {
                if (resultset != null) {
                    resultset.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.log.error((Object)"Error closing statement or results set during report generation", (Throwable)e);
            }
        }
        return null;
    }

    private String getQueryString(ReportFieldEnum reportField, List<GroupByField> groupByFields, Criterion filter) {
        String selectStatement = this.getSelectStatement(reportField, groupByFields);
        FilterInfo filterInfo = this.getFilterInfo(filter);
        String groupingStatement = this.getGroupingStatement(groupByFields);
        String queryString = selectStatement + filterInfo.getFilterSubQuery() + groupingStatement;
        return queryString;
    }

    private String getSelectStatement(ReportFieldEnum reportField, List<GroupByField> groupByFields) {
        ReportFieldType selectType = reportField.getType();
        return "SELECT " + selectType.getSelectFieldString(groupByFields) + " FROM profile_resource_node AS profile ";
    }

    private FilterInfo getFilterInfo(Criterion filter) {
        FilterInfo filterInfo = new FilterInfo();
        QueryBuilder queryBuilder = QueryBuilder.forAlias((String)"profileResourceNode").createAlias("format");
        queryBuilder.add(filter);
        String ejbQl = queryBuilder.toEjbQl();
        if (ejbQl.length() > 0) {
            filterInfo.setFilterSubQuery(this.buildFilterSubQuery(ejbQl));
            filterInfo.setFilterValues(queryBuilder.getValues());
        }
        return filterInfo;
    }

    private String getGroupingStatement(List<GroupByField> groupByFields) {
        StringBuilder groupByFieldQuery = new StringBuilder();
        if (groupByFields != null && groupByFields.size() > 0) {
            boolean puidGroup = false;
            boolean formatMetadataGroup = false;
            for (GroupByField group : groupByFields) {
                ReportFieldEnum groupField = group.getGroupByField();
                puidGroup |= this.groupOnPUID(groupField);
                formatMetadataGroup |= this.groupOnFormatMetadata(groupField);
            }
            if (formatMetadataGroup) {
                groupByFieldQuery.append(" INNER JOIN identification as ident on ident.node_id = profile.node_id  INNER JOIN format as format on format.puid = ident.puid ");
            } else if (puidGroup) {
                groupByFieldQuery.append(" INNER JOIN identification as format on format.node_id = profile.node_id ");
            }
            groupByFieldQuery.append(this.getGroupByClause(groupByFields));
        }
        return groupByFieldQuery.toString();
    }

    private String getGroupByClause(List<GroupByField> groupByFields) {
        StringBuilder groupByFieldQuery = new StringBuilder();
        groupByFieldQuery.append("GROUP BY ");
        String separator = "";
        for (GroupByField group : groupByFields) {
            String groupFieldName = group.getGroupByField().getType().getField();
            String groupFunction = group.getFunction();
            groupByFieldQuery.append(separator);
            if (groupFunction != null && !groupFunction.isEmpty()) {
                groupByFieldQuery.append(groupFunction + "(");
            }
            groupByFieldQuery.append(groupFieldName);
            if (groupFunction != null && !groupFunction.isEmpty()) {
                groupByFieldQuery.append(") ");
            }
            separator = ", ";
        }
        return groupByFieldQuery.toString();
    }

    private String buildFilterSubQuery(String ejbQl) {
        String filterSQL = SqlUtils.transformEJBtoSQLFields(ejbQl, "filter", formatfilter);
        String subQuery = " INNER JOIN (SELECT DISTINCT filter.node_id  FROM profile_resource_node AS filter ";
        if (this.filterOnFormats(filterSQL)) {
            subQuery = this.filterOnFormatMetadata(filterSQL) ? subQuery + " INNER JOIN identification as formatident ON formatident.node_id = filter.node_id  INNER JOIN format as formatfilter ON formatfilter.puid = formatident.puid " : subQuery + " INNER JOIN identification as formatfilter ON formatfilter.node_id = filter.node_id ";
        }
        subQuery = subQuery + " WHERE " + filterSQL + ") AS filtered " + " ON filtered.node_id = profile.node_id ";
        return subQuery;
    }

    private boolean filterOnFormats(String queryString) {
        return queryString.contains(formatfilter);
    }

    private boolean filterOnFormatMetadata(String queryString) {
        return queryString.contains("formatfilter.name") || queryString.contains("formatfilter.mime_type");
    }

    private boolean groupOnPUID(ReportFieldEnum groupByField) {
        return groupByField.equals((Object)ReportFieldEnum.PUID);
    }

    private boolean groupOnFormatMetadata(ReportFieldEnum groupByField) {
        return groupByField.equals((Object)ReportFieldEnum.FILE_FORMAT) || groupByField.equals((Object)ReportFieldEnum.MIME_TYPE);
    }

    private void setFilterParameters(PreparedStatement s, Criterion filter) {
        FilterInfo filterInfo = this.getFilterInfo(filter);
        Object[] filterParams = filterInfo.getFilterValues();
        int pos = 0;
        for (Object param : filterParams) {
            Object transformedValue = SqlUtils.transformParameterToSQLValue(param);
            try {
                String className = transformedValue.getClass().getSimpleName();
                switch (SqlUtils.ClassName.valueOf(className)) {
                    case String: {
                        s.setString(++pos, (String)transformedValue);
                        break;
                    }
                    case Date: {
                        java.util.Date d = (java.util.Date)transformedValue;
                        s.setDate(++pos, new Date(d.getTime()));
                        break;
                    }
                    case Long: {
                        s.setLong(++pos, (Long)transformedValue);
                        break;
                    }
                    case Integer: {
                        s.setInt(++pos, (Integer)transformedValue);
                        break;
                    }
                    default: {
                        this.log.error((Object)"Invalid filter parameter type in SQLReportDaoImpl.java");
                        break;
                    }
                }
            }
            catch (SQLException e) {
                this.log.error((Object)e);
            }
        }
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    private class FilterInfo {
        private String filterSubQuery = "";
        private Object[] filterValues = new Object[0];

        private FilterInfo() {
        }

        public String getFilterSubQuery() {
            return this.filterSubQuery;
        }

        public Object[] getFilterValues() {
            return this.filterValues;
        }

        public void setFilterSubQuery(String subQuery) {
            this.filterSubQuery = subQuery;
        }

        public void setFilterValues(Object[] values) {
            this.filterValues = values;
        }
    }
}

