/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.File;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.submitter.SubmitterUtils;

public class DirectoryEventHandler {
    private static final int URI_STRING_BUILDER_CAPACITY = 1024;
    private ResultHandler resultHandler;
    private StringBuilder uriStringBuilder = new StringBuilder(1024);

    public ResourceId onEvent(File dir, ResourceId parentId, int depth, boolean restricted) {
        IdentificationResultImpl result = new IdentificationResultImpl();
        result.setMethod(IdentificationMethod.NULL);
        RequestMetaData metaData = new RequestMetaData(Long.valueOf(dir.length()), Long.valueOf(dir.lastModified()), depth == 0 ? dir.getAbsolutePath() : dir.getName());
        RequestIdentifier identifier = new RequestIdentifier(SubmitterUtils.toURI(dir, this.uriStringBuilder));
        identifier.setParentResourceId(parentId);
        result.setRequestMetaData(metaData);
        result.setIdentifier(identifier);
        return this.resultHandler.handleDirectory((IdentificationResult)result, parentId, restricted);
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }
}

