/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class JobCounter {
    private final Lock lock = new ReentrantLock();
    private final Condition idle = this.lock.newCondition();
    private final AtomicInteger jobCount = new AtomicInteger(0);
    private final AtomicInteger postProcessCount = new AtomicInteger(0);

    JobCounter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increment() {
        this.lock.lock();
        try {
            this.jobCount.incrementAndGet();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementPostProcess() {
        this.lock.lock();
        try {
            this.postProcessCount.incrementAndGet();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrement() {
        this.lock.lock();
        try {
            int cnt = this.jobCount.decrementAndGet();
            if (cnt == 0) {
                this.idle.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementPostProcess() {
        this.lock.lock();
        try {
            int cnt = this.postProcessCount.decrementAndGet();
            if (cnt == 0) {
                this.idle.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitFinished() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.jobCount.get() > 0 || this.postProcessCount.get() > 0) {
                this.idle.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitIdle() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.jobCount.get() > 0) {
                this.idle.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

