/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.submitter.ProfileWalkState;

public class ProfileWalkerDao {
    private static final String FILE_WALKER_XML = "profile_progress.xml";
    private final Log log = LogFactory.getLog(this.getClass());
    private final JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProfileWalkState.class});
    private String profileHomeDir;

    public ProfileWalkState load() {
        File xml = new File(this.profileHomeDir, FILE_WALKER_XML);
        if (xml.exists()) {
            try {
                Unmarshaller unmarshaller = this.context.createUnmarshaller();
                ProfileWalkState walkState = (ProfileWalkState)unmarshaller.unmarshal(xml);
                return walkState;
            }
            catch (JAXBException e) {
                this.log.error((Object)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return new ProfileWalkState();
    }

    public void save(ProfileWalkState walkState) {
        File xml = new File(this.profileHomeDir, FILE_WALKER_XML);
        try {
            Marshaller m = this.context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)walkState, xml);
        }
        catch (PropertyException e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void delete() {
        File xml = new File(this.profileHomeDir, FILE_WALKER_XML);
        if (!xml.delete() && xml.exists()) {
            String message = String.format("Could not delete file walker xml file: %s. Will try to delete on exit.", xml.getAbsolutePath());
            this.log.warn((Object)message);
            xml.deleteOnExit();
        }
    }

    public void setProfileHomeDir(String profileHomeDir) {
        this.profileHomeDir = profileHomeDir;
    }
}

