/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.util;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;

public final class FileUtil {
    private static final int BYTES_IN_KILOBYTE = 1024;

    private FileUtil() {
    }

    public static boolean isSymbolicLink(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        File fileInCanonicalDir = null;
        if (file.getParent() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    public static String formatFileSize(long fileSize, int decimalPos) {
        double size;
        double val;
        NumberFormat fmt = NumberFormat.getNumberInstance();
        if (decimalPos >= 0) {
            fmt.setMaximumFractionDigits(decimalPos);
        }
        String formattedSize = (val = (size = (double)fileSize) / 1.073741824E9) > 1.0 ? fmt.format(val).concat(" GB") : ((val = size / 1048576.0) > 1.0 ? fmt.format(val).concat(" MB") : ((val = size / 1024.0) > 1.0 ? fmt.format(val).concat(" KB") : fmt.format(size).concat(" bytes")));
        return formattedSize;
    }
}

