/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.SailBaseIteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSailConnection
implements SailConnection {
    private static final int BLOCK_SIZE = 1000;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean debugEnabled = AbstractSail.debugEnabled();
    private final AbstractSail sailBase;
    private volatile boolean isOpen;
    private volatile boolean txnActive;
    private volatile boolean txnPrepared;
    protected final ReentrantReadWriteLock connectionLock = new ReentrantReadWriteLock();
    protected final ReentrantLock updateLock = new ReentrantLock();
    private final Map<SailBaseIteration, Throwable> activeIterations = new IdentityHashMap<SailBaseIteration, Throwable>();
    private final Map<UpdateContext, Collection<Statement>> removed = new HashMap<UpdateContext, Collection<Statement>>();
    private final Map<UpdateContext, Collection<Statement>> added = new HashMap<UpdateContext, Collection<Statement>>();
    private final BNode wildContext = SimpleValueFactory.getInstance().createBNode();
    private IsolationLevel transactionIsolationLevel;

    public AbstractSailConnection(AbstractSail sailBase) {
        this.sailBase = sailBase;
        this.isOpen = true;
        this.txnActive = false;
    }

    @Override
    public final boolean isOpen() throws SailException {
        return this.isOpen;
    }

    protected void verifyIsOpen() throws SailException {
        if (!this.isOpen) {
            throw new IllegalStateException("Connection has been closed");
        }
    }

    protected void verifyIsActive() throws SailException {
        if (!this.isActive()) {
            throw new SailException("No active transaction");
        }
    }

    @Override
    public void begin() throws SailException {
        this.begin(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin(IsolationLevel level) throws SailException {
        IsolationLevel compatibleLevel;
        if (level == null) {
            level = this.sailBase.getDefaultIsolationLevel();
        }
        if ((compatibleLevel = IsolationLevels.getCompatibleIsolationLevel((IsolationLevel)level, this.sailBase.getSupportedIsolationLevels())) == null) {
            throw new UnknownSailTransactionStateException("Isolation level " + level + " not compatible with this Sail");
        }
        this.transactionIsolationLevel = compatibleLevel;
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                if (this.isActive()) {
                    throw new SailException("a transaction is already active on this connection.");
                }
                this.startTransactionInternal();
                this.txnActive = true;
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
        this.startUpdate(null);
    }

    protected IsolationLevel getTransactionIsolation() {
        return this.transactionIsolationLevel;
    }

    @Override
    public boolean isActive() throws UnknownSailTransactionStateException {
        return this.transactionActive();
    }

    @Override
    public final void close() throws SailException {
        block10: {
            this.connectionLock.writeLock().lock();
            try {
                if (!this.isOpen) break block10;
                try {
                    this.forceCloseActiveOperations();
                    if (this.txnActive) {
                        this.logger.warn("Rolling back transaction due to connection close", this.debugEnabled ? new Throwable() : null);
                        try {
                            this.rollbackInternal();
                        }
                        finally {
                            this.txnActive = false;
                            this.txnPrepared = false;
                        }
                    }
                    this.closeInternal();
                }
                finally {
                    this.isOpen = false;
                    this.sailBase.connectionClosed(this);
                }
            }
            finally {
                this.connectionLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.flushPendingUpdates();
        this.connectionLock.readLock().lock();
        try {
            CloseableIteration<? extends BindingSet, QueryEvaluationException> closeableIteration;
            block21: {
                this.verifyIsOpen();
                boolean registered = false;
                CloseableIteration<? extends BindingSet, QueryEvaluationException> iteration = null;
                CloseableIteration<? extends BindingSet, QueryEvaluationException> registeredIteration = null;
                try {
                    iteration = this.evaluateInternal(tupleExpr, dataset, bindings, includeInferred);
                    registeredIteration = this.registerIteration(iteration);
                    registered = true;
                    closeableIteration = registeredIteration;
                    if (registered) break block21;
                }
                catch (Throwable throwable) {
                    if (!registered) {
                        try {
                            try {
                                if (registeredIteration != null) {
                                    registeredIteration.close();
                                }
                            }
                            finally {
                                if (iteration != null) {
                                    iteration.close();
                                }
                            }
                        }
                        catch (QueryEvaluationException e) {
                            throw new SailException(e);
                        }
                    }
                    throw throwable;
                }
                try {
                    try {
                        if (registeredIteration != null) {
                            registeredIteration.close();
                        }
                    }
                    finally {
                        if (iteration != null) {
                            iteration.close();
                        }
                    }
                }
                catch (QueryEvaluationException e) {
                    throw new SailException(e);
                }
            }
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public final CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        this.flushPendingUpdates();
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Resource, SailException> closeableIteration = this.registerIteration(this.getContextIDsInternal());
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        this.connectionLock.readLock().lock();
        try {
            CloseableIteration<? extends Statement, SailException> closeableIteration;
            block7: {
                this.verifyIsOpen();
                boolean registered = false;
                CloseableIteration<? extends Statement, SailException> iteration = this.getStatementsInternal(subj, pred, obj, includeInferred, contexts);
                try {
                    CloseableIteration<? extends Statement, SailException> registeredIteration = this.registerIteration(iteration);
                    registered = true;
                    closeableIteration = registeredIteration;
                    if (registered) break block7;
                }
                catch (Throwable throwable) {
                    if (!registered) {
                        iteration.close();
                    }
                    throw throwable;
                }
                iteration.close();
            }
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long size(Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            long l = this.sizeInternal(contexts);
            return l;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    protected final boolean transactionActive() {
        return this.txnActive;
    }

    @Deprecated
    protected void autoStartTransaction() throws SailException {
        this.verifyIsActive();
    }

    @Override
    public void flush() throws SailException {
        if (this.isActive()) {
            this.endUpdate(null);
            this.startUpdate(null);
        }
    }

    @Override
    public final void prepare() throws SailException {
        if (this.isActive()) {
            this.endUpdate(null);
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                if (this.txnActive) {
                    this.prepareInternal();
                    this.txnPrepared = true;
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public final void commit() throws SailException {
        if (this.isActive()) {
            this.endUpdate(null);
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                if (this.txnActive) {
                    if (!this.txnPrepared) {
                        this.prepareInternal();
                    }
                    this.commitInternal();
                    this.txnActive = false;
                    this.txnPrepared = false;
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollback() throws SailException {
        block16: {
            Map<UpdateContext, Collection<Statement>> map = this.added;
            synchronized (map) {
                this.added.clear();
            }
            map = this.removed;
            synchronized (map) {
                this.removed.clear();
            }
            this.connectionLock.readLock().lock();
            try {
                this.verifyIsOpen();
                this.updateLock.lock();
                try {
                    if (this.txnActive) {
                        try {
                            this.rollbackInternal();
                            break block16;
                        }
                        finally {
                            this.txnActive = false;
                            this.txnPrepared = false;
                        }
                    }
                    this.logger.warn("Cannot rollback transaction on connection because transaction is not active", this.debugEnabled ? new Throwable() : null);
                }
                finally {
                    this.updateLock.unlock();
                }
            }
            finally {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    @Override
    public final void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.pendingRemovals()) {
            this.flushPendingUpdates();
        }
        this.addStatement(null, subj, pred, obj, contexts);
    }

    @Override
    public final void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        this.removeStatement(null, subj, pred, obj, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUpdate(UpdateContext op) throws SailException {
        if (op != null) {
            this.flushPendingUpdates();
        }
        Map<UpdateContext, Collection<Statement>> map = this.removed;
        synchronized (map) {
            assert (!this.removed.containsKey(op));
            this.removed.put(op, new LinkedList());
        }
        map = this.added;
        synchronized (map) {
            assert (!this.added.containsKey(op));
            this.added.put(op, new LinkedList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatement(UpdateContext op, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, Collection<Statement>> map = this.added;
        synchronized (map) {
            assert (this.added.containsKey(op));
            Collection<Statement> pending = this.added.get(op);
            if (contexts == null || contexts.length == 0) {
                pending.add(this.sailBase.getValueFactory().createStatement(subj, pred, obj));
            } else {
                for (Resource ctx : contexts) {
                    pending.add(this.sailBase.getValueFactory().createStatement(subj, pred, obj, ctx));
                }
            }
            if (pending.size() % 1000 == 0 && !this.isActiveOperation()) {
                this.endUpdate(op);
                this.startUpdate(op);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatement(UpdateContext op, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, Collection<Statement>> map = this.removed;
        synchronized (map) {
            assert (this.removed.containsKey(op));
            Collection<Statement> pending = this.removed.get(op);
            if (contexts == null) {
                pending.add(new WildStatement(subj, pred, obj));
            } else if (contexts.length == 0) {
                pending.add(new WildStatement(subj, pred, obj, (Resource)this.wildContext));
            } else {
                for (Resource ctx : contexts) {
                    pending.add(new WildStatement(subj, pred, obj, ctx));
                }
            }
            if (pending.size() % 1000 == 0 && !this.isActiveOperation()) {
                this.endUpdate(op);
                this.startUpdate(op);
            }
        }
    }

    @Override
    public final void endUpdate(UpdateContext op) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.endUpdateInternal(op);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
            if (op != null) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endUpdateInternal(UpdateContext op) throws SailException {
        Collection<Statement> model;
        Object object = this.removed;
        synchronized (object) {
            model = this.removed.remove(op);
        }
        if (model != null) {
            for (Statement st : model) {
                Resource ctx = st.getContext();
                if (this.wildContext.equals((Object)ctx)) {
                    this.removeStatementsInternal(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[0]);
                    continue;
                }
                this.removeStatementsInternal(st.getSubject(), st.getPredicate(), st.getObject(), ctx);
            }
        }
        object = this.added;
        synchronized (object) {
            model = this.added.remove(op);
        }
        if (model != null) {
            for (Statement st : model) {
                this.addStatementInternal(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
            }
        }
    }

    @Override
    public final void clear(Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.clearInternal(contexts);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public final CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Namespace, SailException> closeableIteration = this.registerIteration(this.getNamespacesInternal());
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public final String getNamespace(String prefix) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            String string = this.getNamespaceInternal(prefix);
            return string;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setNamespace(String prefix, String name) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.setNamespaceInternal(prefix, name);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public final void removeNamespace(String prefix) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.removeNamespaceInternal(prefix);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public final void clearNamespaces() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.clearNamespacesInternal();
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    protected Lock getSharedConnectionLock() throws SailException {
        return new JavaLock(this.connectionLock.readLock());
    }

    protected Lock getExclusiveConnectionLock() throws SailException {
        return new JavaLock(this.connectionLock.writeLock());
    }

    @Deprecated
    protected Lock getTransactionLock() throws SailException {
        return new JavaLock(this.updateLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, E extends Exception> CloseableIteration<T, E> registerIteration(CloseableIteration<T, E> iter) {
        SailBaseIteration<T, E> result = new SailBaseIteration<T, E>(iter, this);
        Throwable stackTrace = this.debugEnabled ? new Throwable() : null;
        Map<SailBaseIteration, Throwable> map = this.activeIterations;
        synchronized (map) {
            this.activeIterations.put(result, stackTrace);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterationClosed(SailBaseIteration iter) {
        Map<SailBaseIteration, Throwable> map = this.activeIterations;
        synchronized (map) {
            this.activeIterations.remove((Object)iter);
        }
    }

    protected abstract void closeInternal() throws SailException;

    protected abstract CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr var1, Dataset var2, BindingSet var3, boolean var4) throws SailException;

    protected abstract CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException;

    protected abstract CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource var1, IRI var2, Value var3, boolean var4, Resource ... var5) throws SailException;

    protected abstract long sizeInternal(Resource ... var1) throws SailException;

    protected abstract void startTransactionInternal() throws SailException;

    protected void prepareInternal() throws SailException {
    }

    protected abstract void commitInternal() throws SailException;

    protected abstract void rollbackInternal() throws SailException;

    protected abstract void addStatementInternal(Resource var1, IRI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void removeStatementsInternal(Resource var1, IRI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void clearInternal(Resource ... var1) throws SailException;

    protected abstract CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException;

    protected abstract String getNamespaceInternal(String var1) throws SailException;

    protected abstract void setNamespaceInternal(String var1, String var2) throws SailException;

    protected abstract void removeNamespaceInternal(String var1) throws SailException;

    protected abstract void clearNamespacesInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActiveOperation() {
        Map<SailBaseIteration, Throwable> map = this.activeIterations;
        synchronized (map) {
            return !this.activeIterations.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceCloseActiveOperations() throws SailException {
        IdentityHashMap<SailBaseIteration, Throwable> activeIterationsCopy;
        Map<SailBaseIteration, Throwable> map = this.activeIterations;
        synchronized (map) {
            activeIterationsCopy = new IdentityHashMap<SailBaseIteration, Throwable>(this.activeIterations);
            this.activeIterations.clear();
        }
        ArrayList<SailException> toThrowExceptions = new ArrayList<SailException>();
        for (Map.Entry entry : activeIterationsCopy.entrySet()) {
            SailBaseIteration ci = (SailBaseIteration)((Object)entry.getKey());
            Throwable creatorTrace = (Throwable)entry.getValue();
            try {
                if (creatorTrace != null) {
                    this.logger.warn("Forced closing of unclosed iteration that was created in:", this.debugEnabled ? creatorTrace : null);
                }
                ci.close();
            }
            catch (SailException e) {
                toThrowExceptions.add(e);
            }
            catch (Exception e) {
                toThrowExceptions.add(new SailException(e));
            }
        }
        if (!toThrowExceptions.isEmpty()) {
            throw (SailException)((Object)toThrowExceptions.get(0));
        }
    }

    private void flushPendingUpdates() throws SailException {
        if (!this.isActiveOperation() || this.isActive() && !this.getTransactionIsolation().isCompatibleWith((IsolationLevel)IsolationLevels.SNAPSHOT_READ)) {
            this.flush();
        }
    }

    private static class JavaLock
    implements Lock {
        private final java.util.concurrent.locks.Lock javaLock;
        private boolean isActive = true;

        public JavaLock(java.util.concurrent.locks.Lock javaLock) {
            this.javaLock = javaLock;
            javaLock.lock();
        }

        @Override
        public synchronized boolean isActive() {
            return this.isActive;
        }

        @Override
        public synchronized void release() {
            if (this.isActive) {
                this.javaLock.unlock();
                this.isActive = false;
            }
        }
    }

    private class WildStatement
    implements Statement {
        private static final long serialVersionUID = 3363010521961228565L;
        private final Resource subject;
        private final IRI predicate;
        private final Value object;
        private final Resource context;

        public WildStatement(Resource subject, IRI predicate, Value object) {
            this(subject, predicate, object, null);
        }

        public WildStatement(Resource subject, IRI predicate, Value object, Resource context) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
            this.context = context;
        }

        public Resource getSubject() {
            return this.subject;
        }

        public IRI getPredicate() {
            return this.predicate;
        }

        public Value getObject() {
            return this.object;
        }

        public Resource getContext() {
            return this.context;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(256);
            sb.append("(");
            sb.append(this.getSubject());
            sb.append(", ");
            sb.append(this.getPredicate());
            sb.append(", ");
            sb.append(this.getObject());
            sb.append(")");
            sb.append(" [").append(this.getContext()).append("]");
            return sb.toString();
        }
    }
}

