/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.conformance;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import gov.loc.repository.bagit.conformance.BagProfileChecker;
import gov.loc.repository.bagit.conformance.BagitWarning;
import gov.loc.repository.bagit.conformance.EncodingChecker;
import gov.loc.repository.bagit.conformance.ManifestChecker;
import gov.loc.repository.bagit.conformance.MetadataChecker;
import gov.loc.repository.bagit.conformance.VersionChecker;
import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Version;
import gov.loc.repository.bagit.exceptions.InvalidBagMetadataException;
import gov.loc.repository.bagit.exceptions.InvalidBagitFileFormatException;
import gov.loc.repository.bagit.exceptions.UnparsableVersionException;
import gov.loc.repository.bagit.exceptions.conformance.BagitVersionIsNotAcceptableException;
import gov.loc.repository.bagit.exceptions.conformance.FetchFileNotAllowedException;
import gov.loc.repository.bagit.exceptions.conformance.MetatdataValueIsNotAcceptableException;
import gov.loc.repository.bagit.exceptions.conformance.MetatdataValueIsNotRepeatableException;
import gov.loc.repository.bagit.exceptions.conformance.RequiredManifestNotPresentException;
import gov.loc.repository.bagit.exceptions.conformance.RequiredMetadataFieldNotPresentException;
import gov.loc.repository.bagit.exceptions.conformance.RequiredTagFileNotPresentException;
import gov.loc.repository.bagit.reader.BagitTextFileReader;
import gov.loc.repository.bagit.reader.KeyValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BagLinter {
    private static final Logger logger = LoggerFactory.getLogger(BagLinter.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    private static final Version VERSION_1_0 = new Version(1, 0);

    private BagLinter() {
    }

    public static void checkAgainstProfile(InputStream jsonProfile, Bag bag) throws JsonParseException, JsonMappingException, IOException, FetchFileNotAllowedException, RequiredMetadataFieldNotPresentException, MetatdataValueIsNotAcceptableException, RequiredManifestNotPresentException, BagitVersionIsNotAcceptableException, RequiredTagFileNotPresentException, MetatdataValueIsNotRepeatableException {
        BagProfileChecker.bagConformsToProfile(jsonProfile, bag);
    }

    public static Set<BagitWarning> lintBag(Path rootDir) throws IOException, UnparsableVersionException, InvalidBagMetadataException, InvalidBagitFileFormatException {
        return BagLinter.lintBag(rootDir, Collections.emptyList());
    }

    public static Set<BagitWarning> lintBag(Path rootDir, Collection<BagitWarning> warningsToIgnore) throws IOException, UnparsableVersionException, InvalidBagMetadataException, InvalidBagitFileFormatException {
        HashSet<BagitWarning> warnings = new HashSet<BagitWarning>();
        Path bagitDir = rootDir.resolve(".bagit");
        if (!Files.exists(bagitDir, new LinkOption[0])) {
            bagitDir = rootDir;
        }
        Path bagitFile = bagitDir.resolve("bagit.txt");
        BagLinter.checkForExtraLines(bagitFile, warnings, warningsToIgnore);
        AbstractMap.SimpleImmutableEntry<Version, Charset> bagitInfo = BagitTextFileReader.readBagitTextFile(bagitFile);
        logger.info(messages.getString("checking_encoding_problems"));
        EncodingChecker.checkEncoding(bagitInfo.getValue(), warnings, warningsToIgnore);
        logger.info(messages.getString("checking_latest_version"));
        VersionChecker.checkVersion(bagitInfo.getKey(), warnings, warningsToIgnore);
        logger.info(messages.getString("checking_manifest_problems"));
        ManifestChecker.checkManifests(bagitDir, bagitInfo.getValue(), warnings, warningsToIgnore);
        logger.info(messages.getString("checking_metadata_problems"));
        MetadataChecker.checkBagMetadata(bagitDir, bagitInfo.getValue(), warnings, warningsToIgnore);
        return warnings;
    }

    private static void checkForExtraLines(Path bagitFile, Collection<BagitWarning> warnings, Collection<BagitWarning> warningsToIgnore) throws InvalidBagMetadataException, IOException, UnparsableVersionException {
        if (warningsToIgnore.contains((Object)BagitWarning.EXTRA_LINES_IN_BAGIT_FILES)) {
            logger.debug(messages.getString("skipping_check_extra_lines"));
            return;
        }
        logger.debug(messages.getString("checking_extra_lines"));
        List<AbstractMap.SimpleImmutableEntry<String, String>> pairs = KeyValueReader.readKeyValuesFromFile(bagitFile, ":", StandardCharsets.UTF_8);
        for (AbstractMap.SimpleImmutableEntry<String, String> pair : pairs) {
            if (!"BagIt-Version".equals(pair.getKey())) continue;
            Version version = BagitTextFileReader.parseVersion(pair.getValue());
            if (pairs.size() <= 2 || !version.isOlder(VERSION_1_0)) continue;
            logger.warn(messages.getString("extra_lines_warning"), (Object)pairs.size());
            warnings.add(BagitWarning.EXTRA_LINES_IN_BAGIT_FILES);
        }
    }
}

