/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer;

import gov.loc.repository.bagit.domain.Version;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BagitFileWriter {
    private static final Logger logger = LoggerFactory.getLogger(BagitFileWriter.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    private BagitFileWriter() {
    }

    public static void writeBagitFile(Version version, Charset encoding, Path outputDir) throws IOException {
        Path bagitPath = outputDir.resolve("bagit.txt");
        logger.debug(messages.getString("write_bagit_file_to_path"), (Object)outputDir);
        String firstLine = "BagIt-Version: " + version + System.lineSeparator();
        logger.debug(messages.getString("writing_line_to_file"), (Object)firstLine, (Object)bagitPath);
        Files.write(bagitPath, firstLine.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        String secondLine = "Tag-File-Character-Encoding: " + encoding + System.lineSeparator();
        logger.debug(messages.getString("writing_line_to_file"), (Object)secondLine, (Object)bagitPath);
        Files.write(bagitPath, secondLine.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.APPEND);
    }
}

