/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import uk.gov.nationalarchives.droid.container.ContainerSignature;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.FileFormatMapping;
import uk.gov.nationalarchives.droid.core.interfaces.DroidCore;

public class ContainerIdentifierInit {
    private List<String> uniqueFileEntries;
    private List<ContainerSignature> containerSignatures = new ArrayList<ContainerSignature>();

    public void init(ContainerSignatureDefinitions defs, String containerType, Map<Integer, List<FileFormatMapping>> formats, DroidCore droidCore) {
        HashSet<String> uniqueFileSet = new HashSet<String>();
        for (ContainerSignature sig : defs.getContainerSignatures()) {
            if (!sig.getContainerType().equals(containerType)) continue;
            this.addContainerSignature(sig);
            uniqueFileSet.addAll(sig.getFiles().keySet());
        }
        this.uniqueFileEntries = new ArrayList<String>(uniqueFileSet);
        for (FileFormatMapping fmt : defs.getFormats()) {
            List<FileFormatMapping> mappings = formats.get(fmt.getSignatureId());
            if (mappings == null) {
                mappings = new ArrayList<FileFormatMapping>();
                formats.put(fmt.getSignatureId(), mappings);
            }
            mappings.add(fmt);
            if (droidCore == null) continue;
            droidCore.removeSignatureForPuid(fmt.getPuid());
        }
    }

    public void addContainerSignature(ContainerSignature containerSignature) {
        this.containerSignatures.add(containerSignature);
    }

    public List<ContainerSignature> getContainerSignatures() {
        return this.containerSignatures;
    }

    public List<String> getUniqueFileEntries() {
        return this.uniqueFileEntries;
    }
}

