/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container.ole2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import uk.gov.nationalarchives.droid.container.AbstractIdentifierEngine;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatch;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatchCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;

public class Ole2IdentifierEngine
extends AbstractIdentifierEngine {
    private static final String NO_READER_ERROR = "No reader was obtained for %s. This may be due to low memory conditions. Try running with a larger heap size!";
    private static final Log LOG = LogFactory.getLog(Ole2IdentifierEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(IdentificationRequest request, ContainerSignatureMatchCollection matches) throws IOException {
        InputStream in = request.getSourceInputStream();
        POIFSFileSystem reader = null;
        try {
            block18: {
                try {
                    if (FileSystemIdentificationRequest.class.isAssignableFrom(request.getClass())) {
                        FileSystemIdentificationRequest req = (FileSystemIdentificationRequest)FileSystemIdentificationRequest.class.cast(request);
                        reader = new POIFSFileSystem(req.getFile());
                    } else {
                        reader = new POIFSFileSystem(in);
                    }
                    if (reader != null) break block18;
                }
                catch (Throwable throwable) {
                    if (reader != null) throw throwable;
                    String identifier = request.getIdentifier() != null ? request.getIdentifier().getUri().toString() : "the current container file";
                    throw new IOException(String.format(NO_READER_ERROR, identifier));
                }
                String identifier = request.getIdentifier() != null ? request.getIdentifier().getUri().toString() : "the current container file";
                throw new IOException(String.format(NO_READER_ERROR, identifier));
            }
            DirectoryNode root = reader.getRoot();
            Iterator it = root.getEntries();
            block10: while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                String entryName = entry.getName().trim();
                boolean needsBinaryMatch = false;
                for (ContainerSignatureMatch match : matches.getContainerSignatureMatches()) {
                    match.matchFileEntry(entryName);
                    if (!match.needsBinaryMatch(entryName)) continue;
                    needsBinaryMatch = true;
                }
                if (!needsBinaryMatch) continue;
                DocumentInputStream docIn = null;
                ByteReader byteReader = null;
                try {
                    docIn = reader.createDocumentInputStream(entry.getName());
                    byteReader = this.newByteReader((InputStream)docIn);
                    Iterator<ContainerSignatureMatch> i$ = matches.getContainerSignatureMatches().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block10;
                        ContainerSignatureMatch match = i$.next();
                        match.matchBinaryContent(entryName, byteReader);
                    }
                }
                finally {
                    if (byteReader != null) {
                        byteReader.close();
                    }
                    if (docIn == null) continue;
                    docIn.close();
                }
            }
            return;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
            return;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }
}

