/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.ead.C;
import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.mdconfig.LevelMetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAttribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class LevelOfDescription
implements Serializable {
    private static final String DEFAULT_LEVELS_FILE_NAME = "./config/levels.xml";
    private static String DefaultAllowedValuesSeparator = ";";
    private static String InitializationFilePath = "./config/levels.xml";
    private static String AllowedValuesSeparator = DefaultAllowedValuesSeparator;
    private static Map<String, LevelOfDescription> All = new HashMap<String, LevelOfDescription>();
    private static List<LevelOfDescription> AllOrdered = new Vector<LevelOfDescription>();
    private static LevelOfDescription Undefined;
    private String name;
    private Integer order;
    private ImageIcon icon;
    private Set<String> allowedSubLevelNames = new HashSet<String>();
    private String defaultSubLevelName;
    private Map<String, LevelMetadataElement> levelMetadataElements = new HashMap<String, LevelMetadataElement>();
    private List<LevelMetadataElement> levelMetadataElementsOrdered = new Vector<LevelMetadataElement>();
    @XmlAttribute(name="isTrash")
    protected Boolean isTrash = Boolean.FALSE;

    LevelOfDescription(String name, int order) {
        this.name = name;
        this.order = order;
        Logger.debug((Object)("Created: " + this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LevelOfDescription(String name, String iconFileName, String allowedSubLevelNames, Boolean isTrash) {
        this.name = name;
        if (isTrash != null) {
            this.isTrash = isTrash;
        }
        Map<String, LevelOfDescription> map = All;
        synchronized (map) {
            this.order = All.size();
            if (!All.containsKey(name)) {
                All.put(name, this);
                AllOrdered.add(this);
            }
        }
        if (this.order == 0) {
            Undefined = this;
        }
        this.setIcon(iconFileName);
        if (allowedSubLevelNames != null && !allowedSubLevelNames.trim().isEmpty()) {
            String[] allAllowedSubLevelNames = allowedSubLevelNames.split("\\s+");
            this.defaultSubLevelName = allAllowedSubLevelNames[0];
            for (String subLevelName : allAllowedSubLevelNames) {
                this.allowedSubLevelNames.add(subLevelName);
            }
        }
        Logger.debug((Object)("Created standard Level: " + this));
    }

    private void setIcon(String iconFileName) {
        this.icon = this.getImageIcon(iconFileName);
    }

    private ImageIcon getImageIcon(String filename) {
        if (filename == null || filename.trim().isEmpty()) {
            return null;
        }
        if (new File(filename).exists()) {
            return new ImageIcon(filename);
        }
        URL url = ResourceUtil.getResourceURL((String)filename);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitializationFilePath(String initializationFilePath) {
        InitializationFilePath = initializationFilePath;
        Map<String, LevelOfDescription> map = All;
        synchronized (map) {
            All.clear();
            AllOrdered.clear();
            MetadataElement.clear();
        }
        AllowedValuesSeparator = DefaultAllowedValuesSeparator;
    }

    static String getInitializationFilePath() {
        return InitializationFilePath;
    }

    public static String getInitializationFileAbsolutePath() {
        return LevelOfDescription.getFile(LevelOfDescription.getInitializationFilePath()).getAbsolutePath();
    }

    public static boolean isInitializationFileFound(String initializationFilePath) {
        if (new File(initializationFilePath).exists()) {
            return true;
        }
        return ResourceUtil.getResourceURL((String)initializationFilePath) != null;
    }

    public static void setAllowedValuesSeparator(String sep) {
        AllowedValuesSeparator = sep;
    }

    public static LevelOfDescription getUndefined() {
        LevelOfDescription.initializeIfNecessary();
        return Undefined;
    }

    public static String getAllowedValuesSeparator() {
        return AllowedValuesSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        Logger.debug((Object)("Initializing LevelOfDescriptions from file: " + LevelOfDescription.getInitializationFilePath()));
        Map<String, LevelOfDescription> map = All;
        synchronized (map) {
            MetadataElement.clear();
            All = new ConcurrentHashMap<String, LevelOfDescription>();
            AllOrdered = new Vector<LevelOfDescription>();
        }
        try {
            Document levelsConfigFile = LevelOfDescription.readLevelsDocument(LevelOfDescription.getInitializationFilePath());
            Element rootElement = levelsConfigFile.getRootElement();
            Logger.debug((Object)"Reading optional AllowedValuesSeparator:");
            Node n = rootElement.selectSingleNode("./LEVELS:MetadataElements/LEVELS:AllowedValuesSeparator");
            if (n != null) {
                LevelOfDescription.setAllowedValuesSeparator(n.getText());
            }
            Logger.debug((Object)"Reading MetadataElements:");
            for (Object e : rootElement.selectNodes("./LEVELS:MetadataElements/LEVELS:MetadataElement")) {
                Element mde = (Element)e;
                try {
                    new MetadataElement(C.class, mde.attributeValue("accessorNameID"), mde.attributeValue("validatorClassName"), mde.attributeValue("postActionClassName"), mde.attributeValue("defaultExpression"), mde.attributeValue("allowedValues"), mde.attributeValue("allowedValuesType"));
                }
                catch (Exception ex) {
                    ch.docuteam.tools.exception.Exception.remember((Throwable)ex);
                }
            }
            Logger.debug((Object)"Reading MetadataElements finished.");
            Logger.debug((Object)"Reading Levels:");
            for (Object l : rootElement.selectNodes("./LEVELS:Levels/LEVELS:Level")) {
                Element le = (Element)l;
                LevelOfDescription level = new LevelOfDescription(le.attributeValue("nameID"), le.attributeValue("iconFileName"), le.attributeValue("allowedSublevelNameRefs"), Boolean.valueOf(le.attributeValue("isTrash")));
                for (Object o : le.selectNodes("./LEVELS:LevelMetadataElement")) {
                    LevelMetadataElement levelMetadataElement;
                    Element lme = (Element)o;
                    try {
                        levelMetadataElement = new LevelMetadataElement(level, lme.attributeValue("accessorNameRef"), lme.attributeValue("isMandatory"), lme.attributeValue("isAlwaysDisplayed"), lme.attributeValue("isRepeatable"), lme.attributeValue("isReadOnly"), lme.attributeValue("keepInTemplate"), lme.attributeValue("displayRows"));
                    }
                    catch (MetadataElementIsNotDefinedException ex) {
                        ch.docuteam.tools.exception.Exception.remember((Throwable)ex);
                        continue;
                    }
                    level.levelMetadataElements.put(levelMetadataElement.getId(), levelMetadataElement);
                    level.levelMetadataElementsOrdered.add(levelMetadataElement);
                }
            }
            Logger.debug((Object)"Reading Levels finished.");
        }
        catch (DocumentException ex) {
            Logger.error((Object)("Could not properly read the levels configuration file: " + LevelOfDescription.getInitializationFileAbsolutePath()), (Throwable)ex);
        }
    }

    private static Document readLevelsDocument(String pathname) throws DocumentException {
        Document levelsConfigFile;
        File initializationFile = LevelOfDescription.getFile(pathname);
        if (initializationFile != null) {
            levelsConfigFile = new SAXReader().read(initializationFile);
        } else {
            Logger.debug((Object)"read levelsConfigFile from the classpath as resource URL");
            levelsConfigFile = new SAXReader().read(ResourceUtil.getResourceURL((String)pathname));
        }
        return levelsConfigFile;
    }

    private static File getFile(String pathname) {
        File file = new File(pathname);
        if (file.exists()) {
            return file;
        }
        file = ResourceUtil.getResource((String)pathname);
        if (file == null) {
            Logger.debug((Object)("cannot get file for the pathname: " + pathname));
        }
        return file;
    }

    static List<LevelOfDescription> getAll() {
        LevelOfDescription.initializeIfNecessary();
        return AllOrdered;
    }

    static void initializeIfNecessary() {
        if (All.isEmpty()) {
            LevelOfDescription.initialize();
        }
    }

    public String getName() {
        return this.name;
    }

    public Integer getOrder() {
        return this.order;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public Set<String> getAllowedSubLevelNames() {
        return this.allowedSubLevelNames;
    }

    public LevelOfDescription getDefaultSubLevel() {
        return this.defaultSubLevelName != null ? All.get(this.defaultSubLevelName) : LevelOfDescription.getUndefined();
    }

    public Map<String, LevelMetadataElement> getDynamicMetadataElements() {
        return this.levelMetadataElements;
    }

    public LevelMetadataElement getDynamicMetadataElement(String accessorName) throws MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException {
        if (!this.levelMetadataElements.containsKey(accessorName)) {
            if (MetadataElement.get(accessorName) == null) {
                throw new MetadataElementIsNotDefinedException(this, accessorName);
            }
            throw new MetadataElementIsNotAllowedException(this, accessorName);
        }
        return this.levelMetadataElements.get(accessorName);
    }

    public List<LevelMetadataElement> getDynamicMetadataElementsOrdered() {
        return this.levelMetadataElementsOrdered;
    }

    public boolean allowsSubLevel(String name) {
        return this.allowedSubLevelNames.contains(name);
    }

    public boolean allowsSubLevel(LevelOfDescription level) {
        return this.allowedSubLevelNames.contains(level.name);
    }

    public boolean isUndefined() {
        return this == Undefined;
    }

    public String toString() {
        return this.order + ":" + this.name;
    }

    public boolean isLevelNameEqualsWith(String trashLevelName) {
        return this.getName().equals(trashLevelName);
    }

    public Boolean isTrash() {
        return this.isTrash;
    }

    public void setIsTrash(Boolean isTrash) {
        this.isTrash = isTrash;
    }
}

