/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.translations.I18N;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;

public class MetadataElementValidatorDate
implements MetadataElementValidator {
    private final DateFormat StandardDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Pattern StandardDatePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");

    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (value.equals(I18N.translate_NoCheck((String)"NoDate"))) {
            return;
        }
        if (!StandardDatePattern.matcher(value).matches()) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateCantConvert", (Object[])new Object[]{value}));
        }
        try {
            this.StandardDateFormat.parse(value);
        }
        catch (ParseException ex) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateCantConvert", (Object[])new Object[]{value}));
        }
    }
}

