/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public class MetadataElementValidatorUniqueValueAmongSiblings
implements MetadataElementValidator {
    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        if (context.isRoot().booleanValue()) {
            return;
        }
        String errorMessage = null;
        try {
            for (MutableTreeTableNode child : ((NodeFolder)context.getParent()).getChildren()) {
                if (child == context || !((NodeAbstract)child).getAllDynamicMetadataValuesForName(metadataElement.getAccessorName()).contains(value)) continue;
                errorMessage = I18N.translate_NoCheck((String)"MessageValidatorUniqueValueAmongSiblings", (Object[])new Object[]{value, I18N.translate_NoCheck((String)metadataElement.getId())});
                break;
            }
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            errorMessage = ex.getMessage();
        }
        if (errorMessage != null) {
            throw new MetadataElementValidatorException(errorMessage);
        }
    }
}

