/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.util;

import ch.docuteam.tools.string.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.tree.DefaultText;

public abstract class XMLUtil {
    public static Element add(Element parentElement, String xPath) {
        return XMLUtil.addElements(parentElement, xPath, false);
    }

    public static Element add(Element parentElement, String xPath, String textValue) {
        return XMLUtil.add(parentElement, xPath, Arrays.asList(textValue));
    }

    public static Element add(Element parentElement, String xPath, List<String> textValues) {
        return XMLUtil.addElementsWithTexts(parentElement, xPath, textValues, false);
    }

    public static Element set(Element parentElement, String xPath) {
        return XMLUtil.addElements(parentElement, xPath, true);
    }

    public static Element set(Element parentElement, String xPath, String textValue) {
        return XMLUtil.set(parentElement, xPath, Arrays.asList(textValue));
    }

    public static Element set(Element parentElement, String xPath, List<String> textValues) {
        return XMLUtil.addElementsWithTexts(parentElement, xPath, textValues, true);
    }

    public static String asParentPath(String xpath) {
        if (xpath == null) {
            return null;
        }
        if (xpath.contains("/")) {
            return xpath.substring(0, xpath.lastIndexOf("/"));
        }
        return null;
    }

    private static Element addElements(Element element, String xPath, boolean doDeleteExistingElements) {
        if (doDeleteExistingElements) {
            for (Object node : element.selectNodes(xPath)) {
                ((Node)node).detach();
            }
        }
        List xPathElements = StringUtil.split((String)xPath, (String)"/");
        Element lastIntermediaryElement = XMLUtil.createIntermediaryElements(element, xPathElements);
        return XMLUtil.addElement(lastIntermediaryElement, (String)xPathElements.get(xPathElements.size() - 1));
    }

    private static Element addElementsWithTexts(Element element, String xPath, List<String> textValues, boolean doDeleteExistingElements) {
        Element lastIntermediaryElement;
        if (doDeleteExistingElements) {
            for (Object node : element.selectNodes(xPath)) {
                ((Node)node).detach();
            }
        }
        if (textValues == null) {
            return element;
        }
        List xPathElements = StringUtil.split((String)xPath, (String)"/");
        xPathElements.set(xPathElements.size() - 1, ((String)xPathElements.get(xPathElements.size() - 1)).replaceAll("\\[(not\\(@\\w+\\)( and )?)+\\]", ""));
        Element lastAddedElement = lastIntermediaryElement = XMLUtil.createIntermediaryElements(element, xPathElements);
        String prefix = lastAddedElement.getNamespacePrefix();
        if (prefix != null && prefix.equals("EAD")) {
            for (String s : textValues) {
                String ts;
                String string = ts = s == null ? "" : s.trim();
                if (!Pattern.compile("\\R").matcher(ts).find()) {
                    lastAddedElement = XMLUtil.addElement(lastIntermediaryElement, (String)xPathElements.get(xPathElements.size() - 1));
                    lastAddedElement.setText(ts);
                    continue;
                }
                lastAddedElement = XMLUtil.addElement(lastIntermediaryElement, (String)xPathElements.get(xPathElements.size() - 1));
                String[] lines = ts.split("\\R");
                for (int i = 0; i < lines.length; ++i) {
                    lastAddedElement.add((Text)new DefaultText(lines[i].trim()));
                    if (i >= lines.length - 1) continue;
                    XMLUtil.addElement(lastAddedElement, "EAD:lb");
                }
            }
        } else {
            for (String s : textValues) {
                lastAddedElement = XMLUtil.addElement(lastIntermediaryElement, (String)xPathElements.get(xPathElements.size() - 1));
                lastAddedElement.setText(s == null ? "" : s);
            }
        }
        return lastAddedElement;
    }

    private static Element createIntermediaryElements(Element element, List<String> xPathElements) {
        Element parentElement = element;
        for (int i = 0; i < xPathElements.size() - 1; ++i) {
            String xPathElement = xPathElements.get(i);
            if (xPathElement.equals(".")) continue;
            Element newElement = (Element)parentElement.selectSingleNode(xPathElement);
            if (newElement == null) {
                newElement = XMLUtil.addElement(parentElement, xPathElement);
            }
            parentElement = newElement;
        }
        return parentElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element addElement(Element parentElement, String xPathElement) {
        if (!xPathElement.contains("[@")) {
            return parentElement.addElement(xPathElement);
        }
        Element newElement = null;
        try (Scanner s = new Scanner(xPathElement);){
            s.findInLine("(.+)\\[@(\\w*) *= *'([^']*).*'\\]");
            MatchResult result = s.match();
            newElement = parentElement.addElement(result.group(1));
            if (result.group(2) != null && result.group(3) != null) {
                newElement.addAttribute(result.group(2), result.group(3));
            }
        }
        return newElement;
    }
}

